#include "config.h"

RCSID("$Id: kstring2key.c,v 1.4 1996/03/28 13:46:37 bg Exp $");

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <des.h>
#include <krb.h>

#define VERIFY 0

static char *program;

static int
Usage()
{
    fprintf(stderr, "%s: Usage: %s [-c AFS cellname] [ password ]\n",
	    program, program);
    exit(0);
}

int
main(argc, argv)
     int argc;
     char **argv;
{
    des_cblock key;
    char buf[1024];
    char *cellname = 0;

    program = argv[0];
    if (argc >= 3 && argv[1][0] == '-' && argv[1][1] == 'c')
	{
	    cellname = argv[2];
	    argv += 2;
	    argc -= 2;
	}
    if (argc >= 2 && argv[1][0] == '-' && argv[1][1] == 'h')
	Usage();

    switch (argc) {
    case 1:
	if (des_read_pw_string(buf, sizeof(buf)-1, "password: ", VERIFY))
	    {
		fprintf(stderr, "Error reading password.\n");
		exit(1);
	    }
	break;
    case 2:
	strcpy(buf, argv[1]);
	break;
    default:
	Usage();
	break;
    }

    if (cellname != 0)
	afs_string_to_key(buf, cellname, &key);
    else
	des_string_to_key(buf, &key);

    {
	int j;
	unsigned char *tkey = (unsigned char *) &key;
	for(j = 0; j < 8; j++)
	    if(tkey[j] != '\\' && isalpha(tkey[j]) != 0)
		printf("%c", tkey[j]);
	    else
		printf("\\%03o",(unsigned char)tkey[j]);
	printf("\n");
    }
    exit(0);
}
