/*
 * This software may now be redistributed outside the US.
 *
 */

/* 
  Copyright (C) 1989 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */

/*
 * change your password with kerberos
 */

#include "kadm_locl.h"

RCSID("$Id: kpasswd.c,v 1.16 1996/06/14 09:44:47 assar Exp $");

#ifdef NOENCRYPTION
#define read_long_pw_string placebo_read_pw_string
#else
#define read_long_pw_string des_read_pw_string
#endif
    
static void
usage(int value)
{
    fprintf(stderr, "Usage: ");
    fprintf(stderr, "kpasswd [-h ] [-n user] [-i instance] [-r realm] ");
    fprintf(stderr, "[-u fullname]\n");
    exit(value);
}

int
main(int argc, char **argv)
{
    char name[ANAME_SZ];	/* name of user */
    char inst[INST_SZ];		/* instance of user */
    char realm[REALM_SZ];	/* realm of user */
    char default_name[ANAME_SZ];
    char default_inst[INST_SZ];
    char default_realm[REALM_SZ];
    int realm_given = 0;	/* True if realm was give on cmdline */
    int use_default = 1;	/* True if we should use default name */
    struct passwd *pw;
    int status;			/* return code */
    char pword[MAX_KPW_LEN];
    int c;
    char tktstring[MaxPathLen];
    
    memset(name, 0, sizeof(name));
    memset(inst, 0, sizeof(inst));
    memset(realm, 0, sizeof(realm));
    
    if (krb_get_tf_fullname(TKT_FILE, default_name, default_inst, 
			    default_realm) != KSUCCESS) {
	pw = getpwuid((int) getuid());
	if (pw)
	    (void) strcpy(default_name, pw->pw_name);
	else
	    /* seems like a null name is kinda silly */
	    (void) strcpy(default_name, ""); 
	strcpy(default_inst, "");
	if (krb_get_lrealm(default_realm, 1) != KSUCCESS)
	    strcpy(default_realm, "NO.DEFAULT.REALM");
    }

    while ((c = getopt(argc, argv, "u:n:i:r:h")) != EOF) {
	switch (c) {
	  case 'u':
	    if ((status = kname_parse(name, inst, realm, optarg))) {
		fprintf(stderr, "Kerberos error: %s\n", krb_get_err_text(status));
		exit(2);
	    }
	    if (realm[0])
		realm_given++;
	    else
		if (krb_get_lrealm(realm, 1) != KSUCCESS)
		    strcpy(realm, "NO.DEFAULT.REALM");
	    break;
	  case 'n':
	    if (k_isname(optarg))
		(void) strncpy(name, optarg, sizeof(name) - 1);
	    else {
		fprintf(stderr, "Bad name: %s\n", optarg);
		usage(1);
	    }
	    break;
	  case 'i':
	    if (k_isinst(optarg))
		(void) strncpy(inst, optarg, sizeof(inst) - 1);
	    else {
		fprintf(stderr, "Bad instance: %s\n", optarg);
		usage(1);
	    }
	    (void) strcpy(inst, optarg);
	    break;
	  case 'r':
	    if (k_isrealm(optarg)) {
		(void) strncpy(realm, optarg, sizeof(realm) - 1);
		realm_given++; 
	    }
	    else {
		fprintf(stderr, "Bad realm: %s\n", optarg);
		usage(1);
	    }
	    break;
	  case 'h':
	    usage(0);
	    break;
	  default:
	    usage(1);
	    break;
	}
	use_default = 0;
    }
    if (optind < argc){
	use_default = 0;
	status = kname_parse(name, inst, realm, argv[optind]);
	if(status != KSUCCESS){
	    fprintf(stderr, "Kerberos error: %s\n", krb_get_err_text(status));
	    exit(1);
	}
    }

    if (use_default) {
	strcpy(name, default_name);
	strcpy(inst, default_inst);
	strcpy(realm, default_realm);
    }
    else {
	if (!name[0])
	    strcpy(name, default_name);
	if (!realm[0])
	    strcpy(realm, default_realm);
    }

    (void) sprintf(tktstring, TKT_ROOT "_cpw_%d",(int)getpid());
    krb_set_tkt_string(tktstring);
    
    if (get_pw_new_pwd(pword, sizeof(pword), name, inst, realm,
		       realm_given)) {
      dest_tkt ();
      exit(1);
    }
    
    status = kadm_init_link("changepw", KRB_MASTER, realm);
    if (status != KADM_SUCCESS) 
      com_err(argv[0], status, "while initializing");
    else {
      des_cblock newkey;
      char *pw_msg; /* message from server */

      des_string_to_key(pword, &newkey);
      status = kadm_change_pw_plain((unsigned char*)&newkey, pword, &pw_msg);
      memset(newkey, 0, sizeof(newkey));
      
      if (status == KADM_INSECURE_PW)
	fprintf(stderr, "%s: Insecure password: %s\n", argv[0], pw_msg);
      else if (status != KADM_SUCCESS)
	com_err(argv[0], status, " attempting to change password.");
    }
    memset(pword, 0, sizeof(pword));

    if (status != KADM_SUCCESS)
      fprintf(stderr,"Password NOT changed.\n");
    else
      printf("Password changed.\n");

    (void) dest_tkt();
    if (status)
      exit(2);
    else 
      exit(0);
}
