/*
 * Copyright 1987, 1988 by MIT Student Information Processing Board
 *
 * For copyright information, see copyright.h.
 */

#ifndef _ss_ss_internal_h
#define _ss_ss_internal_h __FILE__
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "ss.h"

typedef struct _ss_abbrev_entry {
    char *name;			/* abbrev name */
    char **abbrev;		/* new tokens to insert */
    unsigned int beginning_of_line : 1;
} ss_abbrev_entry;

typedef struct _ss_abbrev_list {
    int n_abbrevs;
    ss_abbrev_entry *first_abbrev;
} ss_abbrev_list;

typedef struct {
/*    char *path; */
    ss_abbrev_list abbrevs[127];
} ss_abbrev_info;

typedef struct _ss_data {	/* init values */
    /* this subsystem */
    char *subsystem_name;
    char *subsystem_version;
    /* current request info */
    int argc;
    char **argv;		/* arg list */
    char const *current_request; /* primary name */
    /* info directory for 'help' */
    char **info_dirs;
    /* to be extracted by subroutines */
    void *info_ptr;		/* (void *) NULL */
    /* for ss_listen processing */
    char *prompt;
    ss_request_table **rqt_tables;
    ss_abbrev_info *abbrev_info;
    struct {
      unsigned int escape_disabled : 1;
      unsigned abbrevs_disabled : 1;
    } flags;
    /* to get out */
    int abort;			/* exit subsystem */
    int exit_status;
} ss_data;

#define CURRENT_SS_VERSION 1

#define	ss_info(sci_idx)	(_ss_table[sci_idx])
#define	ss_current_request(sci_idx,code_ptr)	\
     (*code_ptr=0,ss_info(sci_idx)->current_request)
void ss_unknown_function();
void ss_delete_info_dir();
int ss_execute_line();
char **ss_parse();
ss_abbrev_info *ss_abbrev_initialize (char *, int *);
void ss_page_stdin();
void write_ct(const char *hdr, const char *rql);
char * generate_cmds_string(const char *cmds);
void generate_function_definition(const char *func);
char * generate_rqte(const char *func_name, const char *info_string, 
		     const char *cmds, int options);
char *str_concat3(char *a, char *b, char *c);
char *quote(char *string);
char *ds(char *s);
long flag_val(char *string);
void ss_delete_invocation(int sci_idx);
void ss_add_info_dir(int sci_idx, char *info_dir, int *code_ptr);
void ss_add_info_dir(int sci_idx, char *info_dir, int *code_ptr);
int ss_execute_line (int sci_idx, char *line_ptr);
void ss_abort_subsystem(int sci_idx, int code);
void ss_quit(int argc, char **argv, int sci_idx, void *infop);
char **ss_parse (int sci_idx, char *line_ptr, int *argc_ptr);
char * ss_name(int sci_idx);
void ss_set_prompt(int sci_idx, char *new_prompt);
char *ss_get_prompt(int sci_idx);
void ss_add_request_table(int sci_idx, ss_request_table *rqtbl_ptr, 
			  int position, int *code_ptr);
void ss_delete_request_table(int sci_idx, ss_request_table *rqtbl_ptr,
			     int *code_ptr);
void ss_list_requests(int argc, const char * const *argv, int sci_idx,
		      void *info_ptr);
void ss_page_stdin(void);
int ss_pager_create(void);
void ss_self_identify(int argc, int sci_idx, char **argv);
void ss_subsystem_name(int argc, int sci_idx, char **argv);
void ss_subsystem_version(int argc, int sci_idx, char **argv);
void ss_unimplemented(int argc, int sci_idx, char **argv);

extern ss_data **_ss_table;
extern char *ss_et_msgs[];

#endif /* _ss_internal_h */
