/* logwtmp.c: Put an entry in the wtmp file.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified at NRL for OPIE 2.0.
	Originally from BSD.
*/
/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef lint
static char sccsid[] = "@(#)logwtmp.c	5.7 (Berkeley) 2/25/91";

#endif	/* not lint */

#include "opie_cfg.h"

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <utmp.h>
#include <unistd.h>
#include <string.h>

static int fd = -1;

#if DOUTMPX
static int fdx = -1;

/* SYSV has utmp AND utmpx rather than an enhanced utmp */
/* Also see the defines in opie_cfg.h */
#include <utmpx.h>
#endif	/* DOUTMPX */

#ifndef _PATH_WTMP
#define _PATH_WTMP       "/usr/adm/wtmp"
#endif

#ifndef _PATH_WTMPX
#define _PATH_WTMPX     "/usr/adm/wtmpx"
#endif	/* _PATH_UTMPX */



/*
 * Modified version of logwtmp that holds wtmp file open
 * after first call, for use with ftp (which may chroot
 * after login, but before logout).
 */
void logwtmp(line, name, host)
char *line, *name, *host;
{
  struct utmp ut;

#if DOUTMPX
  struct utmpx utx;

#endif	/* DOUTMPX */
  struct stat buf;
  time_t time();

  memset(&ut, 0, sizeof(struct utmp));

  if (fd < 0 && (fd = open(_PATH_WTMP, O_WRONLY | O_APPEND, 0)) < 0)
    return;
  if (fstat(fd, &buf) == 0) {
    strncpy(ut.ut_line, line, sizeof(ut.ut_line));
    strncpy(ut.ut_name, name, sizeof(ut.ut_name));
#if !DOUTMPX
    strncpy(ut.ut_host, host, sizeof(ut.ut_host));
#endif	/* !DOUTMPX */
    time(&ut.ut_time);
    if (write(fd, (char *) &ut, sizeof(struct utmp)) !=
	sizeof(struct utmp))
    ftruncate(fd, buf.st_size);
  }
#if DOUTMPX
  memset(&utx, 0, sizeof(struct utmpx));

  if (fdx < 0 && (fdx = open(WTMPX_FILE, O_WRONLY | O_APPEND, 0)) < 0)
    return;
  if (fstat(fdx, &buf) == 0) {
    strncpy(utx.ut_line, line, sizeof(utx.ut_line));
    strncpy(utx.ut_name, name, sizeof(utx.ut_name));
    strncpy(utx.ut_host, host, sizeof(utx.ut_host));
    gettimeofday(&utx.ut_tv);
    if (write(fdx, (char *) &utx, sizeof(struct utmpx)) !=
	sizeof(struct utmpx))
    ftruncate(fdx, buf.st_size);
  }
#endif	/* DOUTMPX */
}
