/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_types.h	1.10 95/11/16 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * SKIP internal protocol versions
 */
enum {	SKIP_NONE,		/* Cleartext */
	SKIP_V1,		/* SunScreen mode - early draft*/
	SKIP_V2			/* ESP/AH mode */
};

/*
 * maximum size of a crypto variable
 */
#define	MAXVARSZ		24

/*
 * structure describing a crypto variable
 */
typedef struct {
	int			len;
	char			buf[MAXVARSZ];
} skip_key_var_t;

/*
 * useful defines
 */
#define	KEYVARZERO(v)		((v).len = 0)

#define	KEYVAREQUAL(v1, v2)	(((v1).len == (v2).len) && \
				(bcmp((caddr_t) (v1).buf, (caddr_t) (v2).buf,\
							(v1).len) == 0))

#define	KEYVARSET(v1, v2)	(v1).len = (v2).len; \
				bcopy((v2).buf, (v1).buf, (v1).len);

#define KEYTOBUF(k, p)		if ((k).len)  { \
					bcopy((caddr_t)(k).buf, \
						(caddr_t)(p), (k).len); }

#define PARAMSMATCH(p1, p2) 	(bcmp((caddr_t) p1, (caddr_t) p2,\
					((caddr_t) &((p1)->counter_n) - \
					(caddr_t) &((p1)->ip_addr))) == 0)

#define ACLMATCH(p1, p2) 	(bcmp((caddr_t) &((p1)->version),\
					(caddr_t) &((p2)->version),\
					((caddr_t) &((p1)->counter_n) - \
					(caddr_t) &((p1)->version))) == 0)
/*
 * structure describing skip parameters
 */
typedef struct {
	struct in_addr		ip_addr;	/* peer ip address */
	unsigned char		version;	/* SKIP version */
	unsigned char		s_nsid;		/* sender name space id */
	unsigned char		r_nsid;		/* receiver name space id */
	unsigned char		kij_alg;	/* key encryption alg */
	unsigned char		kp_alg;		/* traffic encryption alg */
	unsigned char		mac_alg;	/* ah alg */
	unsigned char		comp_alg;	/* compression alg */
	skip_key_var_t		r_mkeyid;	/* receiver master key id */
	unsigned long		counter_n;	/* counter n	*/
	int			ttl;		/* Time to live	*/
	unsigned char		payload_type;	/* Payload protocol */
} skip_param_t;

/*
 * XXX
 */
extern int	skip_params_debug;
extern int	skip_diffs(char *who, skip_param_t *, skip_param_t *);


#ifndef boolean_t
#define boolean_t       int
#endif
#ifndef B_TRUE
#define B_TRUE          1
#define B_FALSE         0
#endif



#ifdef  __cplusplus
}
#endif
