/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_cache.C	1.12 95/11/21"
 
/*
 * Implements all of the SKIP secret caching, both in core and on disk.
 * This file is a bit yucky because of the RogueWave and G++ code.
 */
 
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "malloc.h"

#include "skip_log.h"
#include "my_types.h"
#include "skip_conf.h"
#include "skip_cache.h"
#include "skip_keymgr.h"
#include "skip_proto.h"

extern secret_cache kij_cache;
extern int verbose;

// Initialize an element in the cache
secret_cache_elem::secret_cache_elem() {
        ncounter=keytype=0;
}
#ifdef RW
Slist local_secrets;
#else
#ifdef LIBG
DLList<local_secret>  local_secrets;
#endif
#endif

// This routine "sets" the n-counter
void 
secret_cache_elem::set_ncounter(u_long ncount) 
{
	Bstream newBstr;
	int offset;

	offset = ncounter - ncount;

	ncounter=ncount;
}

// Encode an element into a binary string so we can write it to disk 
// The basic format is size-of-element, element
Bstream 
secret_cache_elem::encode()
{
	u_int len;
	Bstream result;

// First encode the NSID
	len=sizeof(nsid);
	result  = Bstream(sizeof(len),(u_char *) &len);
	result += Bstream(len, (u_char *)&nsid);

// Encode the key id
	len=keyid.getlength();
	result += Bstream(sizeof(len), (u_char *)&len);
	result += keyid;

// Encode the key type
	len=sizeof(keytype);
	result += Bstream(sizeof(len),(u_char *) &len);
	result += Bstream(len, (u_char *)&keytype);

// Encode the secret
	len=kij.getlength();
	result += Bstream(sizeof(len), (u_char *)&len);
	result += kij;

// Encode the expiration time
	len=sizeof(expires);
	result += Bstream(sizeof(len), (u_char *)&len);
	result += Bstream(sizeof(expires), (u_char *)&expires);

// Here would be a good place to encrypt this data so it's not written to the
// disk in the clear.  But we don't do this yet.

	return result;
}


// Decode a binary stream into a secret_cache_elem.  Basically just the 
// opposite of the above.
int
secret_cache_elem::decode(Bstream in)
{
	u_int len;

// NSID
	if (in.getlength() < sizeof(len))
		return 1;
	memcpy(&len, in.getdatap(), sizeof(len));
	in.consume(sizeof(len));
	if ( in.getlength()<len)
		return 1;
	memcpy(&nsid, in.getdatap(), len);
	in.consume(len);

// Keyid
	if (in.getlength() < sizeof(len))
		return 1;
	memcpy(&len, in.getdatap(), sizeof(len));
	in.consume(sizeof(len));
	if (len > in.getlength())
		return 1;
	keyid = Bstream(len, in.getdatap());
	in.consume(len);

// Keytype
	if (in.getlength() < sizeof(len))
		return 1;
	memcpy(&len, in.getdatap(), sizeof(len));
	in.consume(sizeof(len));
	if (len > in.getlength())
		return 1;
	memcpy(&keytype, in.getdatap(), sizeof(len));
	in.consume(len);
// Kij
	if (in.getlength() < sizeof(len))
		return 1;
	memcpy(&len, in.getdatap(), sizeof(len));
	in.consume(sizeof(len));
	if (len > in.getlength())
		return 1;
	kij= Bstream(len, in.getdatap());
	in.consume(len);

// expires
	if (in.getlength() < sizeof(len))
		return 1;
	memcpy(&len, in.getdatap(), sizeof(len));
	in.consume(sizeof(len));
	if (len > in.getlength())
		return 1;
	memcpy(&expires, in.getdatap(), len);
	len=sizeof(expires);
	ncounter=CURRENT_NCOUNTER;
	return 0;
}

// Simpleminded hash of the keyid.  Currentl only the upper four bytes are
// hashed.
int 
secret_cache::hash(Bstream keyid) {
	int final;
	final=(*(u_long*)keyid.getdatap()) % MAX_HASH;
	return final;
}

secret_cache::secret_cache()
{
	int i;
	for (i=0; i< MAX_HASH; i++) 
		if (table [i] != NULL)
			table[i] = NULL;
}

Bstream
secret_cache::get_secret(u_char nsid, const Bstream keyid)
{
        Bstream nullstr;
        secret_cache_elem *elem;
        elem=get_entry(nsid, keyid);
        if (elem == NULL)
                return nullstr;
        return elem->kij;
}

secret_cache_elem *
secret_cache::get_entry(u_char nsid, const Bstream keyid)
{
	Bstream nullstr;
	u_long now;
	int index;
	now  = time(0)+UNIXSTART;
	index=hash(keyid);
	if (table[index] == NULL)
		return NULL;

#ifdef RW
	Slist *active;
	active=table[index];
	SlistIterator iter(*active);
	secret_cache_elem *next;
	while (next = (secret_cache_elem *)iter()) {
		if (next->keyid == keyid && next->nsid == nsid ) {
			if (next->expires < now  && next->expires != 0) {
				String temp;
				temp=keyid.gethexstr();
				skip_log(SKIP_ERROR,"Error: Expired Certificate for 0x%s", (const char *)temp);
				active->remove(next);
				return NULL;
			}
			return next;
		}
			
	}
#else
#ifdef LIBG
	DLList<secret_cache_elem> *active;
	active=table[index];
	for (Pix i=active->first(); i!=0; active->next(i)) {
		if ((*active)(i).keyid == keyid && (*active)(i).nsid ==nsid) {
			if ((*active)(i).expires <  now && 
			    (*active)(i).expires != 0) {
				String temp;
				temp=keyid.gethexstr();
				skip_log(SKIP_ERROR,"Error: Expired Certificate for 0x%x",(const char*)temp);
				active->del(i);
				return NULL;
			}
			return &((*active)(i));
		}
	}
#endif /* LIBG */

#endif
	return NULL;
}

void
secret_cache::insert(secret_cache_elem *elem)
{
	int offset;
	secret_cache_elem *cached;
	cached = get_entry(elem->nsid, elem->keyid);
	offset=hash(elem->keyid);
	dirty=1;	// Mark the cache as dirty so we can write it.
	if (cached == NULL) {
#ifdef RW
		if (table[offset] == NULL)
			table[offset] = new Slist ;
		table[offset]->insert(elem);
#else
#ifdef LIBG
		if (table[offset] == NULL)
			table[offset] = new DLList<secret_cache_elem>;
		table[offset]->append(*elem);
#endif
#endif
	} else 
		bcopy(elem, cached, sizeof(*elem));
}

void
skip_cache_secret(const Bstream& secret, u_char nsid, const Bstream keyid, 
		  u_long exp, int keytype )
{
	// We need to cap this somehow to
	// avoid growing the secret_cache list 
	// to be arbitrarily large.
	// XXX TBD

	secret_cache_elem *secret_elem = new secret_cache_elem;
	secret_elem->kij = secret;
	secret_elem->keyid = keyid;
	secret_elem->expires = exp;
	secret_elem->ncounter = CURRENT_NCOUNTER;
	secret_elem->keytype =  keytype ;
	secret_elem->nsid = nsid;
	kij_cache.insert(secret_elem);
	return;
}

// Nuke the whole cache
void secret_cache::purge()
{
	int i;
	dirty=0;
	for (i=0; i< MAX_HASH; i++) 
		if (table [i] != NULL) {
#ifdef RW
			table[i]->clearAndDestroy();
#else
#ifdef LIBG
			table[i]->clear();
#endif
#endif
			table[i] = NULL;
		}
}

// Restore the cache from disk.

secret_cache::restore(char *name)
{
	int fd;
	int len;
	int status;
	int ver;
	char buf[2048];
	Bstream encoded;
	secret_cache_elem *n;
	fd=open(name,O_RDONLY);
	if (fd < 0)
		return 1;

// First pull out the version number of the database.  This will be good
// for future database changes.
	status = read(fd, (char *)&ver, sizeof(ver));
	if (status < sizeof(ver)) {
		close(fd);
		return 1;
	}

	if (ver !=  1)			// Only accept version 1 DB
		return 1;

// Read each entry and make a cache entry.  Assume if the file is short
// of corrupted that the entire cache is corrupted and throw it out.
	do {
		status = read(fd, (char *)&len, sizeof(len));
		if (status == 0) {
			close(fd);
			return 0;
		}
		if (status < sizeof(len)) {
			close(fd);
			purge();	// Corrupted cache, purge
			return 1;
		}
		status = read(fd,  buf, len);
		if (status < len) {
			close(fd);
			purge();	// Corrupted cache, purge	
			return 1;
		}
		n=new secret_cache_elem;
		encoded=Bstream(len, (u_char *)buf);
		if (n->decode(encoded)) {
			delete n;
			purge();
			return 1;
		}
		insert(n);
	} while (1); 		// Exists at EOF up earlier
}

// Save the cache to disk
secret_cache::save(char *name)
{
	int fd;
	Bstream encoded;
	int len;
	int i;
	int ver;
	u_long now;
	if (!dirty) 
		return 0;

	now  = time(0)+UNIXSTART;

	unlink(name);
	fd=open(name,O_WRONLY|O_CREAT,0500);
	if (fd < 0)
		return fd;
	ver=1;
	write(fd, (char *)&ver, sizeof(ver));
	
	for (i=0; i< MAX_HASH; i++)  {
		if (table[i]  != NULL) {
#ifdef RW
			Slist *active;
			active=table[i];
			SlistIterator iter(*active);
			secret_cache_elem *next;
			while (next = (secret_cache_elem *)iter()) {
				if (next->expires > now || next->expires > 0) {
					encoded = next->encode();
					len=encoded.getlength();
					write(fd, (char *)&len, sizeof(len));
					write(fd, (char *)encoded.getdatap(), 
					 	  encoded.getlength());
				}
			}
#else
#ifdef LIBG
			DLList<secret_cache_elem> *active;
			active=table[i];
			for (Pix j=active->first(); j!=0; active->next(j)) {
				if ((*active)(j).expires >  now ||
				    (*active)(j).expires >  now) {
					encoded=(*active)(j).encode();
					len=encoded.getlength();
					write(fd, (char *)&len, sizeof(len));
					write(fd, encoded.getdatap(),
					encoded.getlength());
				} // if
			} // for
#endif /* LIBG */
#endif /* RW */
		} // if table
	} // for i
	close(fd);
	dirty=0;
}

	

// Everything below this line is for future use and not currently used.

param::param()
{
	short z=0;
	g=z, p=z, type=KEY_NONE;
}

params::params()
{
	int i;
	data[0]=new param;
	for (i=0;i<MAX_PARAMS; i++)
		data[i]=NULL;
	data[i]=new param;

}

int params::find_param(Bigint g, Bigint  p, int type)
{
	int i;
	for (i=0; data[i]!=NULL && i < MAX_PARAMS ; i++)
		if (data[i]->p == p && data[i]->g == g && 
				data[i]->type == type)
			return i;
	return -1;
}		

int params::add_param(Bigint g, Bigint p, int)
{
	int i;
	for (i=0; data[i]!=NULL && i < MAX_PARAMS ; i++)
		if (data[i]->p == p && data[i]->g == g)
			return i;
	if (i == MAX_PARAMS )
		return -1;
	data[i]->p=p;data[i]->g=g;
	return i;
}

param params::operator[](int n) {
	if (n <= 0 || n > MAX_PARAMS)
		return *data[0];
	return *data[n];
}

local_secret::local_secret()
{
	nsid=params=0;
}

Bstream
find_local_secret(Bstream keyid, u_char nsid, int parm)
{
	Bstream zero;
#ifdef RW
	Slist active;
	SlistIterator iter(local_secrets);
	local_secret *next;
	while (next = (local_secret *)iter()) {
		if (next->keyid == keyid && next->nsid == nsid && 
			next->params == parm)
				return next->secret;
	}
#else
#ifdef LIBG
	for (Pix i=local_secrets.first(); i!=0; local_secrets.next(i)) {
		local_secret temp;
		temp=local_secrets(i);
		if (temp.keyid == keyid && temp.nsid == nsid &&
			temp.params == parm )
			return temp.secret;
	}
#endif /* LIBG */
#endif
	return zero;
}	

void
insert_local_secret(Bstream keyid, Bstream secret, int param, u_char nsid)
{
		local_secret *s;
		s=new local_secret;
		s->keyid=keyid;
		s->secret=secret;
		s->params=param;
		s->nsid=nsid;
#ifdef RW
                local_secrets.insert(s);
#else
#ifdef LIBG
                local_secrets.append(*s);
		delete s;
#endif
#endif
}
