/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_keymgr_init.C	1.18 96/01/16"

/*
 * Author: Ashar Aziz
 */
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <signal.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "ObjId.h"
#include "Name.h"
#include "certx.h"
#include "X509Cert.h"
#include "SkipCert.h"
#include "X509skip.h"
#include "skip_cache.h"
#include "HashCert.h"
#include "malloc.h"
#include "utils.h"
#include "Sig.h"
#include "skip_log.h"

#include "my_types.h"

#include <skip_proto.h>
#include <skip_types.h>
#include <skip_crypt.h>
#include "skip_keymgrmsgs.h"
#include "skip_keymgr.h"
#include "skip_conf.h"
#include "skip_fetchcert.h"


#define BLANKS	" \t"

void rc_manual_key(char *, int);
void rc_lookup_func (char *, int);
void rc_disable(char *, int);
void rc_enable(char *, int);
void rc_setncount(char *, int);
void rc_set_local_id(char *, int);
int add_resolver(int, char *);

struct rc {
	char *name;
	void (*func)(char *, int);
} rc[] = { {"key",     rc_manual_key},
	   {"lookup",  rc_lookup_func},
	   {"disable", rc_disable},
	   {"ncounter", rc_setncount},
	   {"localid", rc_set_local_id}
	};

Bstream mydhsecret;
Bstream dhparams;
Bstream CA_X509_Cert;
u_char mynsid;
time_t secret_expiration;
extern secret_cache kij_cache;

Bigint master_mod, master_base;
int skip_fetch_cert;
int skip_disk_cache;
void *dh_params;
extern int keyfd;

int 
skip_set_keyid(u_char nsid, Bstream keyid)
{
        int size;
        char buf[MGTCSIZE];
        size= make_boxid_msg (nsid, keyid, (void *)buf);
        if (put_skip_msg(keyfd, buf, size) < 0) {
                skip_log(SKIP_ERROR,"Error: Unable to set keyid - exiting\n");
		return 1;
        }
	String temp;
	temp=keyid.gethexstr();
        skip_log(SKIP_NOTICE,"Local Keyid= 0x%s NSID=%d",(const char*)temp, nsid);
	return 0;
}

// Initialization routine for the key manager, testdh, etc.  Takes a
// file descriptor as a parameter.  The descriptor has been opened to
// the SKIP kernel device.  For program like testdh, this is set to zero.
// This routine will setup of the local secret for the key manager
// and extract name and parameters from it's local certificate.  The
// kernel allows multiple name per NSID, so each local certificate is
// used to establish the local name per NSID.

int
skip_keymgr_init(int keyfd)
{
	init_cryptolib();
	Bigint p1, p2, g1, g2;
	int got_local_cert =0;
	time_t exp1, exp2;
	Bstream my_certstr;
	Bigint Bigzero=Bigint((short)0);

	// Let the random number generator kick off it's entropy gathering
	skip_log(SKIP_NOTICE,"Initializing Random Number Generator");
	Bstream dummy=get_random_bytes(1); 	

	skip_setup_fetch(keyfd);

	if (skip_disk_cache) {
		skip_log(SKIP_NOTICE,"Loading cached secrets");
		kij_cache.restore(SKIP_SECRET_CACHE);
	}
	mydhsecret = File_to_Bstr(SKIP_MY_REAL_SECRET_FILE);

	if (mydhsecret.getlength()==0) {
		skip_log(SKIP_NOTICE,"Couldn't open DH secret - DH computations disabled");
			// Cache is probably invalid
			kij_cache.purge();
			if (skip_disk_cache) 
				skip_log(SKIP_NOTICE,"Secret Cache may be out of date, flushing");

			return 0;
	}

	// Purge the cache if either the secret or key manager configuration 
	// file are newer than the secret cache file
	if (skip_disk_cache) {
		if (FileTimeDiff(SKIP_SECRET_CACHE, SKIP_MY_REAL_SECRET_FILE)>0
		    || FileTimeDiff(SKIP_SECRET_CACHE, SKIP_CONF)> 0) {
			skip_log(SKIP_NOTICE,"Disk Cache may be out of date, flushing");
			kij_cache.purge();
		}
	}
	CA_X509_Cert = File_to_Bstr(CA_SELFCERT_FILE);
	if (CA_X509_Cert.getlength() == 0 ) {
		skip_log(SKIP_NOTICE,"warning: unable to open X509 CA Certificate");
	}
	my_certstr = File_to_Bstr(SKIP_MY_X509_CERT_FILE);
	if (my_certstr.getlength()!= 0) {  // validate the local certificate
		X509SkipCert my_cert;
		mynsid=SKIP_NSID_IPV4;
		if (CA_X509_Cert.getlength() == 0) {
			skip_log(SKIP_NOTICE,"X509 Certificate requires nonexistent X509 CA Certificate");
			goto escape;
		} 
		if (my_cert.decode(my_certstr)){
			skip_log(SKIP_ERROR, "Couldn't decode own certificate");
			exit(1);
		} 
		if (!my_cert.isValid(CA_X509_Cert) ) {
			skip_log(SKIP_ERROR,"My certificate is invalid - HELP");
			exit(1);
		}
		if (keyfd) {
			if (skip_set_keyid(mynsid, my_cert.skip_name())){
				exit(1);
			}
		}
		my_cert.skip_params(g1, p1);
		got_local_cert = 1;
		exp1=(time_t)my_cert.skip_notvalidafter()-UNIXSTART;
	} 
escape:	//Yuck, but convenient

	my_certstr = File_to_Bstr(SKIP_MY_HASHED_CERT_FILE);
	if (my_certstr.getlength() != 0) {
		HashCert my_cert;
		mynsid=SKIP_NSID_MD5_DH_PUB;
		if (keyfd) {
			my_cert.decode(my_certstr);
			if (skip_set_keyid(mynsid, my_cert.skip_name())){
				skip_log(SKIP_ERROR,"Unable to set local boxid");
				exit(1);
			}
		}
		my_cert.skip_params(g2, p2);
		got_local_cert = 1;
		exp2=(time_t)my_cert.skip_notvalidafter()-UNIXSTART;
	}	

	if (!got_local_cert) {
		Bstream zero;
		mydhsecret=zero;
		skip_log(SKIP_NOTICE,"No Valid local certificates - DH calculations disabled");
		return 0;
	}

// Set the secret expiration time to the later of the certificates.
	if (exp1< time(0))
		exp1=0;
	if (exp2< time(0))
		exp2=0;

	if (exp1 == 0 && exp2 == 0) {
		skip_log(SKIP_ERROR,"All Local certificates have expired");
		exit(1);
	}
	
	if (exp1 <= exp2)
		secret_expiration=exp2;
	else
		secret_expiration=exp1;

// Make sure if we have multiple certificates that their parameters agree
// since we don't currently support multiple local secrets

	if (g1 == Bigzero || p1 == Bigzero ) {
		if (g2==Bigzero) {
			skip_log(SKIP_ERROR,"Error retrieving local parameters");
			exit(1);
		} else {
			g1 = g2, p1 =  p2;
		}
	} else {
		if (g2 != Bigzero  || p2 != Bigzero ) {
			if (g2 != g1 || p2 != p1) {
				skip_log(SKIP_ERROR,"Conflicting parameters in local certificates");
		       		exit(1);
			}
		} else  {
			p2 =  p1, g2 =  g1;
		}
	}

	master_base = g1;
	master_mod = p1;

// Let the diffie-hellman calculation library chew the parameters up as 
// necessary.
	dh_params = localize_dhparams(master_base, master_mod);
}


// keymgr_read_rc: read the key manager rc file and set up resolvers, manual
// keys and so forth.

void
keymgrd_read_rc()
{
	FILE *fp;
	char buf[255];
	char *bp;
	int line = 0;
	int fired = 0;
	int i;
	char *token;

	fp=fopen(SKIP_CONF,"r");

	if (fp == NULL)  	/* No configuration file, do nothing */
		return;

	while ((bp=fgets(buf,255,fp))!=NULL) {
		line++;
		*(bp+strlen(buf)-1)=(char)0;
		while (isspace(*bp))  		/* strip leading blanks */
			bp++;

		if (*bp == '#')			/* ignore comments */
			continue;

		if (*bp == '\0')		/* ignore blank lines */
			continue;

		token = bp;
		while (!isspace(*bp) && *bp != (char)0)  /* find end of word */
			bp++;

		if (*bp != (char)0) {		/* nuke the excess spaces */
			while (isspace(*bp))  {
				bp++;
				*(bp-1) = (char) 0;
			}
		}

		fired = 0;			/* Did we execute anything */

		// Now loop through each valid command and if it matches,
		// execute the routine.

		for (i = 0; i < sizeof(rc)/sizeof(struct rc); i++ ) {
			if (strcmp(token, rc[i].name) == 0) {
				(rc[i].func)(bp,line);
				fired = 1;
				break;
			}
		}
		if (!fired) {
			skip_log(SKIP_ERROR, "line %d Illegal option in rc file",line);
		}
		fired=0;
	}
	return;
}

// Set up a manual key for the key manager
void rc_manual_key(char *p, int line){
	char *boxids, *secrets, *nsids;
	Bstream secret;
	Bigint temp;
	Bstream boxid;
	u_char nsid;

	boxids=strtok(p, BLANKS);
	if (*boxids == '0' && *(boxids+1) == 'x' && strlen(boxids) > 2){
		Bigint b=Bigint(boxids+2);
		boxid = Bigint_to_Bstr(b);
	} else {
		skip_log(SKIP_ERROR,"line %d Boxid most be a HEX address in this version",line);
		return;
	}

	nsids=strtok(NULL, BLANKS);
	int n=strlen(nsids);
	if (*nsids == '0' && *(nsids+1) == 'x' && n > 2 && n < 5 ){
		Bigint b=Bigint(nsids+2);		
		Bstream t=Bigint_to_Bstr(b);
		nsid=*(t.getdatap());
	} else {
		skip_log(SKIP_ERROR,"line %d Invalid, missing or unsuitable NSID", line);
		return;
	}
	if (nsid == 0) {
		skip_log(SKIP_NOTICE,"Notice: line %d NSID 0 mapped to NSID 1", line);
		nsid = 1;		// Force to IPV4
	}
	
	secrets=strtok(NULL, BLANKS);
	if (*secrets == '0' && *(secrets+1) == 'x' && strlen(secrets) > 2) {
		temp = Bigint(secrets + 2);
		secret = Bigint_to_Bstr(temp);
	} else {
		skip_log(SKIP_ERROR,"line %d Secret must be a hex string in this version",line);
		return;
	}
	if (secret.getlength() <MIN_KIJ_SIZE) { 
		skip_log(SKIP_ERROR,"Line %d Manual key too short for available algorithms must be >= %d",line, MIN_KIJ_SIZE);
		return;
	}
	secret.consume(secret.getlength()-MIN_KIJ_SIZE);
	// set expiration for manual key to never
	skip_cache_secret(secret, nsid, boxid, 0L, KEY_MANUAL);
	skip_log(SKIP_NOTICE,"Manual Secret setup for %s NSID=%d",boxids,nsid);
	return;
}

// function sets up a resolver which does either a directory lookup or
// a bilateral ping

void rc_lookup_func(char *s, int line){
	char *t;

	if (skip_fetch_cert < 0){ /* if fetching is hard disabled, abort */
		skip_log(SKIP_ERROR,"Warning: lookup function is rc file disabled");
		return;
	}
	skip_fetch_cert = 1;
	/* Bilateral exchange */
	if (strncmp(s, "ping",4) == 0) {
		add_resolver(RESOLVE_PING, NULL);
		skip_log(SKIP_NOTICE,"Added PING for certificate exchange");
		return;
	}

	/* Directory lookup */
	if (strncmp(s, "directory", 9) == 0) {
		s+=9;
		if (*s == '(' ) {
			s++;
			t=s;
			while (*t != '\0' && *t != ')') 
				t++;
			*t='\0';
			add_resolver(RESOLVE_PING, s);
			skip_log(SKIP_NOTICE,"Added %s for certificate lookup",s);
			return;	
		}
		skip_log(SKIP_ERROR, "line %d: Syntax error in rc file - missing )",line);
	}
	else 
		skip_log(SKIP_ERROR, "line %d: Syntax error in rc file unknown lookup directive %s",line,s);
	return;
}

// disable certificate fetching all together.
void rc_disable(char *p, int line)
{
	char *token;
	token = strtok(p, BLANKS);
	if ( token == NULL ) {
		skip_log(SKIP_ERROR,"Syntax Error line %d in rc file",line);
		return;
	}
	if (strcmp(token, "lookup") == 0) {
			skip_fetch_cert = -1;
			skip_log(SKIP_NOTICE,"Notice: certificate fetching disabled");
			return;
	}
#ifdef notyet
	if (strcmp(token,"cache") == 0) {
		skip_disk_cache=0;
		skip_log(SKIP_NOTICE,"Notice:Disk Secret cache disabled");
		return;
	}
#endif
	skip_log(SKIP_ERROR,"Unrecognized command disable %s line %d",
			token, line);
}

void rc_setncount(char *p, int line)
{
	
	char *token;
	int freq;
	token = strtok(p, BLANKS);
	if ( token == NULL ) {
		skip_log(SKIP_ERROR,"Syntax Error line %d in rc file",line);
		return;
	}
	freq=atoi(token);
	if (freq==0){
		skip_log(SKIP_ERROR,"Syntax Error line %d in rc file",line);
		return;
	}
	if (freq < 60) {
		skip_log(SKIP_ERROR,"line %d: Unable to set ncounter to less than 60 seconds",line);
		return;
	}
	UPDATE_FREQ=freq;
}


void rc_set_local_id(char *p, int line)
{
	
	char *token;
	char *nsids;
	Bstream boxid;
	char *boxids;
	Bstream localid;
	char nsid;
	nsids = strtok(p, BLANKS);
	if ( nsids == NULL ) {
		skip_log(SKIP_ERROR,"Syntax Error line %d in rc file",line);
		return;
	}

	int n=strlen(nsids);
	if (*nsids == '0' && *(nsids+1) == 'x' && n > 2 && n < 5 ){
		Bigint b=Bigint(nsids+2);		
		Bstream t=Bigint_to_Bstr(b);
		nsid=*(t.getdatap());
	} else {
		skip_log(SKIP_ERROR,"line %d Invalid, missing or unsuitable NSID", line);
		return;
	}

	boxids=strtok(NULL, BLANKS);
	if (*boxids == '0' && *(boxids+1) == 'x' && strlen(boxids) > 2){
		Bigint b=Bigint(boxids+2);
		boxid = Bigint_to_Bstr(b);
	} else {
		skip_log(SKIP_ERROR,"line %d Boxid most be a HEX address in this version",line);
		return;
	}
	skip_set_keyid(nsid, boxid);
}
