/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)ks_ui.c	1.3 95/11/15 Sun Microsystems"

/*
 * ks_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `ks.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "ks_ui.h"

/*
 * Initialize an instance of object `key_stat_win'.
 */
ks_key_stat_win_objects *
ks_key_stat_win_objects_initialize(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (ks_key_stat_win_objects *) calloc(1, sizeof (ks_key_stat_win_objects))))
		return (ks_key_stat_win_objects *) NULL;
	if (!ip->key_stat_win)
		ip->key_stat_win = ks_key_stat_win_key_stat_win_create(ip, owner);
	if (!ip->controls1)
		ip->controls1 = ks_key_stat_win_controls1_create(ip, ip->key_stat_win);
	if (!ip->encrypt_keys)
		ip->encrypt_keys = ks_key_stat_win_encrypt_keys_create(ip, ip->controls1);
	if (!ip->key_icon)
		ip->key_icon = ks_key_stat_win_key_icon_create(ip, ip->controls1);
	if (!ip->percent)
		ip->percent = ks_key_stat_win_percent_create(ip, ip->controls1);
	if (!ip->controls2)
		ip->controls2 = ks_key_stat_win_controls2_create(ip, ip->key_stat_win);
	if (!ip->decrypt_keys)
		ip->decrypt_keys = ks_key_stat_win_decrypt_keys_create(ip, ip->controls2);
	if (!ip->controls3)
		ip->controls3 = ks_key_stat_win_controls3_create(ip, ip->key_stat_win);
	if (!ip->kij_alg)
		ip->kij_alg = ks_key_stat_win_kij_alg_create(ip, ip->controls3);
	if (!ip->kp_alg)
		ip->kp_alg = ks_key_stat_win_kp_alg_create(ip, ip->controls3);
	return ip;
}

/*
 * Create object `key_stat_win' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_key_stat_win_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	extern void	ks_key_stat_win_done_callback(Frame);
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 304,
		XV_HEIGHT, 236,
		XV_LABEL, "SKIP Key status",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		FRAME_DONE_PROC, ks_key_stat_win_done_callback,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls1' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_controls1_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 129,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `encrypt_keys' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_encrypt_keys_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 10,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_LABEL_STRING, "Encryption keys:   ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_UNDERLINED, FALSE,
		PANEL_VALUE, "0",
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `key_icon' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_key_icon_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	key_icon_image;
#include "key.icon"
	
	key_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, key_bits,
		XV_WIDTH, key_width,
		XV_HEIGHT, key_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 30,
		XV_Y, 30,
		PANEL_LABEL_IMAGE, key_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `percent' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_percent_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_GAUGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 150,
		XV_Y, 40,
		PANEL_GAUGE_WIDTH, 100,
		PANEL_TICKS, 20,
		PANEL_LABEL_STRING, "kbytes encrypted",
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_TICK_STRING, "0",
		PANEL_MAX_TICK_STRING, "512k",
		PANEL_VALUE, 0,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls2' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_controls2_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 113,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 51,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `decrypt_keys' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_decrypt_keys_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 10,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_LABEL_STRING, "Decryption keys:   ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_UNDERLINED, FALSE,
		PANEL_VALUE, "0",
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls3' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_controls3_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 151,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_kij_alg_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Key encryption:     ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_UNDERLINED, FALSE,
		PANEL_VALUE, "des_cbc",
		PANEL_INACTIVE, TRUE,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
ks_key_stat_win_kp_alg_create(ks_key_stat_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 50,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_UNDERLINED, FALSE,
		PANEL_VALUE, "rc4",
		PANEL_INACTIVE, TRUE,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

