/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)test.C	1.20 96/07/25"

#include <sys/types.h>
#include <netinet/in.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include <unistd.h>
#include "my_types.h"
#include "Time.h"
#include "Bstream.h"
#include "Bigint.h"
#include "asn1_der.h"
#include "SkipCert.h"
#include "LL.h"
#include "HashCert.h"
#include "CertInfo.h"
#include "CertInfoList.h"
#include "manualcrl.h"

void test2();
void test1();
int bits_in_Bigint(Bigint b);

void
test_certinfo()
{
	printf("CertInfo testing:\n");

	Bigint X("00889fba340000000000010000000000");
	Bigint Y("7089fba340000000000010000000000");
	Bigint Z("25");

	HashCert cert(X,Y,Z, time(0)+UNIXSTART, time(0)+1000+UNIXSTART);
	Bstream name = cert.skip_name();
	CertInfo x(SKIP_DH_PUBLIC, name, &cert);

	if (x.cert->encode() != cert.encode())
		printf("x.cert->encode() != cert.encode()  (BAD)\n");

	printf("CertInfo x created\n");

	Bstream b = x.encode();

	printf("Bstream b = x.encode()\n");

	CertInfo y;

	int ret = CertInfo::decode(b, y);

	printf("decode(b, y) == %d\n", ret);

	if (x.cert == y.cert)
		printf("x.cert == y.cert (wrong)\n");
	else
		printf("x.cert != y.cert (right)\n");

	if (x.cert->encode() == y.cert->encode())
		printf("encodings same (right)\n");
	else
		printf("encodings different (wrong)\n");

	Bigint A("00889fbb340000000000010000000000");
	Bigint B("7189fba340000000000010000000000");
	Bigint C("23");

	HashCert cert2(A,B,C, time(0)+UNIXSTART, time(0)+1000+UNIXSTART);
	Bstream name2 = cert2.skip_name();
	CertInfo z(SKIP_DH_PUBLIC, name2, &cert2);

		SkipCert *p;
		SkipCert *q;

		p = &cert;
		q = &cert2;

		Bstream bp = p->encode();
		Bstream bq = q->encode();

		printf("bp.getlength() == %d\n", bp.getlength());
		bp.print();
		printf("bq.getlength() == %d\n", bq.getlength());
		bq.print();

	if (x.cert->encode() != bp)
		printf("x.cert->encode() != bp  (BAD)\n");

	Bstream c = x.encode() + z.encode();

	CertInfo y1;
	CertInfo y2;
	CertInfo y3;

	ret = CertInfo::decode(c, y1);
	printf("decode(c, y1) == %d (%s)\n", ret, ret == 0 ? "right" : "wrong");

	ret = CertInfo::decode(c, y2);
	printf("decode(c, y2) == %d (%s)\n", ret, ret == 0 ? "right" : "wrong");

	ret = CertInfo::decode(c, y3);
	printf("decode(c, y3) == %d (%s)\n", ret, ret == 0 ? "wrong" : "right");

	if (x.cert->encode() != z.cert->encode())
		printf("x, z encodings different (right)\n");
	else {
		printf("x, z encodings same (wrong)\n");

		Bstream xx = x.cert->encode();
		printf("xx.getlength() == %d\n", xx.getlength());
		xx.print();

		Bstream zz = z.cert->encode();
		printf("zz.getlength() == %d\n", zz.getlength());
		zz.print();
	}

	if (y1.cert->encode() == x.cert->encode())
		printf("x, y1 encodings same (right)\n");
	else
		printf("x, y1 encodings different (wrong)\n");

	if (y2.cert->encode() == z.cert->encode())
		printf("z, y2 encodings same (right)\n");
	else
		printf("z, y2 encodings different (wrong)\n");

	if (y3.cert == 0)
		printf("y3.cert == 0 (right)\n");
	else
		printf("y3.cert != 0 (wrong)\n");

	printf("\n");

	CertInfoList l1;
	CertInfoList l2;

	l1.append(x);
	l1.append(z);

	Bstream l1_s = l1.encode();

	CertInfoList::decode(l1_s, l2);
	CertInfo *ap;

	ap = l2.first();
	if (ap->cert->encode() != x.cert->encode())
		printf("bad1\n");
	ap = l2.next();
	if (ap->cert->encode() != z.cert->encode())
		printf("bad2\n");
}

void
test_dup() {
	Bigint X("00889fba340000000000010000000000");
	Bigint Y("7089fba340000000000010000000000");
	Bigint Z("25");

	if (X != Y) printf("X != Y\n");
	else printf("X == Y\n");
	printf("X= "); X.print(); printf("\n");
	printf("Y= "); Y.print(); printf("\n");
	Bstream x=Bigint_to_Bstr(X);
	x.print();
	test2();
	printf("\n%d\n",X.bits());
	printf("\n%d\n",X.bits());
	HashCert cert(X,Y,Z, time(0)+UNIXSTART, time(0)+1000+UNIXSTART);
	HashCert  empty;
	Bstream certstr=cert.encode();
	cert.skip_name().print();
	cert.print();
        SkipCert *gencert;
	(void) SkipCert::decode(SKIP_DH_PUBLIC, certstr, gencert);
	SkipCert *test;
	test=gencert->dup();
	printf("test->print\n");
	test->print();
}

void btest() 
{
	Bstream foo(10, (byte )0);
	printf("Bstream fill constructor: ");
	if (foo.getlength() != 10 ) {
		printf("failed!\n");
	} else {
		printf("Succeeded\n");	
	}

	Bstream test("01010101");
	Bstream test1;
	Bstream_atob(test1, test);
	test1.print();
}

void test1()
{
	Bigint a(2);
	Bigint b(65000);
	printf("a= "); a.print(); printf("\n");
	printf("b= "); b.print(); printf("\n");

}

void test2()
{
	unsigned char  buf[] = { 0x80, 0x90, 0x10, 0x91};
	int len = sizeof(buf);
	for (int i = 0; i< len; i++)
		printf("buf[%d] = 0x%x\n", i, buf[i]);
	Bigint x (buf, len);

	x.print();
}

main()
{
	btest();
	test_dup();
	test_certinfo();
}

