/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)des_ede_ecb.c	1.4 96/02/02 Sun Microsystems"

#include "des.h"

#ifndef	CPU386

/* C code only in portable version */

/* Encrypt a block of data in ECB mode */
void
endes_ede_ecb(ks1,ks2,ks3,block)
unsigned long ks1[16][2];	/* Key schedule */
unsigned long ks2[16][2];	/* Key schedule */
unsigned long ks3[16][2];	/* Key schedule */
unsigned char block[];		/* Block to be encrypted */
{
	unsigned long left,right;
	unsigned long *keys;

	GETBLOCK(block,left,right);
	IPERM(left,right);

/* encrypt */
	keys = ks1[0];
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,0);

/* decrypt */
	keys = ks2[15];
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,0);

/* encrypt */
	keys = ks3[0];
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,0);

	FPERM(left,right);
	PUTBLOCK(block,right,left);
}

/* Decrypt a block of data in ECB mode */
void
dedes_ede_ecb(ks1,ks2,ks3,block)
unsigned long ks1[16][2];	/* Key schedule */
unsigned long ks2[16][2];	/* Key schedule */
unsigned long ks3[16][2];	/* Key schedule */
unsigned char block[8];		/* Block to be decrypted */
{
	unsigned long left,right;
	unsigned long *keys;

	GETBLOCK(block,left,right);
	IPERM(left,right);

/* decrypt */
	keys = ks3[15];
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left, 0);

/* encrypt */
	keys = ks2[0];
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,1);
	F(right,left,1);
	F(left,right,0);

/* decrypt */
	keys = ks1[15];
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left,-3);
	F(left,right,-3);
	F(right,left, 0);


	FPERM(left,right);
	PUTBLOCK(block,right,left);
}
/* End of portable C code */

#else	/* CPU386 is defined */
386 code note integrated from des.c
#endif

