/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)cdp_queue.h	1.3 96/09/06"

#ifndef CDP_QUEUE_H
#define CDP_QUEUE_H

#include "LL.h"
#include "skipd.h"
#include "skip_keymgr.h"
#include "skip_machdep.h"


#define	RESOLVER_PING	1
#define	RESOLVER_HOST	2
#define RESOLVER_TUNNEL 3

class resolver {
public:
	int kind;
	ip_address server;
};

class cdp_queue_entry {
public:
	remote_info remote;
	void *orig_request;		// original kernel request
	int orig_request_size;

	int request_fd;			// listen to this port fd for reply
	int who_sent;			// position in cdp search list
	resolver* cur_resolver;		// resolver[who_sent]
	int n_try;			// # of times we've sent our request
	time_t time_sent;		// time of send of last request
};

class cdp_queue {
public:
	LL<cdp_queue_entry> l;

	cdp_queue_entry* cdp_queue::first();
	cdp_queue_entry* cdp_queue::next();
	void add_entry(struct remote_info *remote, char *buf, int size);
	void delete_current();
	int check_answer_received(int sock, int kern_fd);
	void heartbeat();
private:
	int check_answer_entry(cdp_queue_entry *p, int sock, int kern_fd);
};

extern void add_cdp_resolver(int kind, char *arg);

#endif
