#ifndef GABA_DEFINE
struct spki_exception
{
  struct exception super;
  struct sexp *expr;
};
extern struct lsh_class spki_exception_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_spki_exception_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct spki_exception *i = (struct spki_exception *) o;
  mark((struct lsh_object *) i->expr);
}

struct lsh_class spki_exception_class =
{ STATIC_HEADER,
  &exception_class, "spki_exception", sizeof(struct spki_exception),
  do_spki_exception_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct spki_algorithm
{
  struct lsh_object super;
  struct signer *(*(make_signer))(struct spki_algorithm *self, struct sexp_iterator *i);
  struct verifier *(*(make_verifier))(struct spki_algorithm *self, struct sexp_iterator *i);
};
extern struct lsh_class spki_algorithm_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class spki_algorithm_class =
{ STATIC_HEADER,
  0, "spki_algorithm", sizeof(struct spki_algorithm),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct spki_5_tuple
{
  struct lsh_object super;
  struct sexp *issuer;
  struct sexp *subject;
  int propagate;
  struct sexp *authorization;
  struct spki_validity validity;
};
extern struct lsh_class spki_5_tuple_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_spki_5_tuple_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct spki_5_tuple *i = (struct spki_5_tuple *) o;
  mark((struct lsh_object *) i->issuer);
  mark((struct lsh_object *) i->subject);
  mark((struct lsh_object *) i->authorization);
}

struct lsh_class spki_5_tuple_class =
{ STATIC_HEADER,
  0, "spki_5_tuple", sizeof(struct spki_5_tuple),
  do_spki_5_tuple_mark,
  NULL
};
#endif /* !GABA_DECLARE */

