#ifndef GABA_DEFINE
struct tcpip_channel
{
  struct ssh_channel super;
  struct io_fd *socket;
};
extern struct lsh_class tcpip_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_channel *i = (struct tcpip_channel *) o;
  mark((struct lsh_object *) i->socket);
}

struct lsh_class tcpip_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "tcpip_channel", sizeof(struct tcpip_channel),
  do_tcpip_channel_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct open_forwarded_tcpip_continuation
{
  struct command_continuation super;
  struct channel_open_callback *response;
};
extern struct lsh_class open_forwarded_tcpip_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_open_forwarded_tcpip_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_forwarded_tcpip_continuation *i = (struct open_forwarded_tcpip_continuation *) o;
  mark((struct lsh_object *) i->response);
}

struct lsh_class open_forwarded_tcpip_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "open_forwarded_tcpip_continuation", sizeof(struct open_forwarded_tcpip_continuation),
  do_open_forwarded_tcpip_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_open_direct_tcpip
{
  struct channel_open super;
  struct command *callback;
};
extern struct lsh_class channel_open_direct_tcpip_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_channel_open_direct_tcpip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_open_direct_tcpip *i = (struct channel_open_direct_tcpip *) o;
  mark((struct lsh_object *) i->callback);
}

struct lsh_class channel_open_direct_tcpip_class =
{ STATIC_HEADER,
  &channel_open_class, "channel_open_direct_tcpip", sizeof(struct channel_open_direct_tcpip),
  do_channel_open_direct_tcpip_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct tcpip_forward_request_continuation
{
  struct command_continuation super;
  struct ssh_connection *connection;
  struct local_port *forward;
  struct global_request_callback *c;
};
extern struct lsh_class tcpip_forward_request_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_forward_request_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_forward_request_continuation *i = (struct tcpip_forward_request_continuation *) o;
  mark((struct lsh_object *) i->connection);
  mark((struct lsh_object *) i->forward);
  mark((struct lsh_object *) i->c);
}

struct lsh_class tcpip_forward_request_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "tcpip_forward_request_continuation", sizeof(struct tcpip_forward_request_continuation),
  do_tcpip_forward_request_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct tcpip_forward_request
{
  struct global_request super;
  struct command *callback;
};
extern struct lsh_class tcpip_forward_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_forward_request_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_forward_request *i = (struct tcpip_forward_request *) o;
  mark((struct lsh_object *) i->callback);
}

struct lsh_class tcpip_forward_request_class =
{ STATIC_HEADER,
  &global_request_class, "tcpip_forward_request", sizeof(struct tcpip_forward_request),
  do_tcpip_forward_request_mark,
  NULL
};
#endif /* !GABA_DECLARE */

