#ifndef GABA_DEFINE
struct pty_request
{
  struct channel_request_command super;
  int tty;
  struct lsh_string *term;
  struct termios ios;
  UINT32 width;
  UINT32 height;
  UINT32 width_p;
  UINT32 height_p;
};
extern struct lsh_class pty_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_pty_request_free(struct lsh_object *o)
{
  struct pty_request *i = (struct pty_request *) o;
  lsh_string_free(i->term);
}

struct lsh_class pty_request_class =
{ STATIC_HEADER,
  &channel_request_command_class, "pty_request", sizeof(struct pty_request),
  NULL,
  do_pty_request_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct pty_request_continuation
{
  struct command_frame super;
  struct pty_request *req;
};
extern struct lsh_class pty_request_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_pty_request_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct pty_request_continuation *i = (struct pty_request_continuation *) o;
  mark((struct lsh_object *) i->req);
}

struct lsh_class pty_request_continuation_class =
{ STATIC_HEADER,
  &command_frame_class, "pty_request_continuation", sizeof(struct pty_request_continuation),
  do_pty_request_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

