#ifndef CLASS_DEFINE
struct read_data
{
  struct read_handler super;
  struct abstract_write *write;
  struct ssh_channel *channel;
};
extern struct lsh_class read_data_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_read_data_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct read_data *i = (struct read_data *) o;
  mark((struct lsh_object *) i->write);
  mark((struct lsh_object *) i->channel);
}

struct lsh_class read_data_class =
{ STATIC_HEADER,
  &read_handler_class, "read_data", sizeof(struct read_data),
  do_read_data_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

