#ifndef GABA_DEFINE
struct command_apply
{
  struct command_frame super;
  struct command *f;
};
extern struct lsh_class command_apply_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_apply_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_apply *i = (struct command_apply *) o;
  mark((struct lsh_object *) i->f);
}

struct lsh_class command_apply_class =
{ STATIC_HEADER,
  &command_frame_class, "command_apply", sizeof(struct command_apply),
  do_command_apply_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct command_S_continuation
{
  struct command_frame super;
  struct command *g;
  struct lsh_object *x;
};
extern struct lsh_class command_S_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_S_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_S_continuation *i = (struct command_S_continuation *) o;
  mark((struct lsh_object *) i->g);
  mark((struct lsh_object *) i->x);
}

struct lsh_class command_S_continuation_class =
{ STATIC_HEADER,
  &command_frame_class, "command_S_continuation", sizeof(struct command_S_continuation),
  do_command_S_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct command_S_2
{
  struct command_simple super;
  struct command *f;
  struct command *g;
};
extern struct lsh_class command_S_2_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_S_2_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_S_2 *i = (struct command_S_2 *) o;
  mark((struct lsh_object *) i->f);
  mark((struct lsh_object *) i->g);
}

struct lsh_class command_S_2_class =
{ STATIC_HEADER,
  &command_simple_class, "command_S_2", sizeof(struct command_S_2),
  do_command_S_2_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct command_S_1
{
  struct command_simple super;
  struct command *f;
};
extern struct lsh_class command_S_1_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_S_1_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_S_1 *i = (struct command_S_1 *) o;
  mark((struct lsh_object *) i->f);
}

struct lsh_class command_S_1_class =
{ STATIC_HEADER,
  &command_simple_class, "command_S_1", sizeof(struct command_S_1),
  do_command_S_1_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct command_K_1
{
  struct command_simple super;
  struct lsh_object *x;
};
extern struct lsh_class command_K_1_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_K_1_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_K_1 *i = (struct command_K_1 *) o;
  mark((struct lsh_object *) i->x);
}

struct lsh_class command_K_1_class =
{ STATIC_HEADER,
  &command_simple_class, "command_K_1", sizeof(struct command_K_1),
  do_command_K_1_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct command_B_2
{
  struct command_simple super;
  struct command *f;
  struct command *g;
};
extern struct lsh_class command_B_2_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_B_2_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_B_2 *i = (struct command_B_2 *) o;
  mark((struct lsh_object *) i->f);
  mark((struct lsh_object *) i->g);
}

struct lsh_class command_B_2_class =
{ STATIC_HEADER,
  &command_simple_class, "command_B_2", sizeof(struct command_B_2),
  do_command_B_2_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct command_B_1
{
  struct command_simple super;
  struct command *f;
};
extern struct lsh_class command_B_1_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_command_B_1_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct command_B_1 *i = (struct command_B_1 *) o;
  mark((struct lsh_object *) i->f);
}

struct lsh_class command_B_1_class =
{ STATIC_HEADER,
  &command_simple_class, "command_B_1", sizeof(struct command_B_1),
  do_command_B_1_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_value
{
  struct lsh_object super;
  int fd;
  struct lsh_string *peername;
  int peerport;
};
extern struct lsh_class listen_value_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_value_free(struct lsh_object *o)
{
  struct listen_value *i = (struct listen_value *) o;
  lsh_string_free(i->peername);
}

struct lsh_class listen_value_class =
{ STATIC_HEADER,
  0, "listen_value", sizeof(struct listen_value),
  NULL,
  do_listen_value_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_command
{
  struct command super;
  struct io_backend *backend;
  struct sockaddr_in address;
};
extern struct lsh_class listen_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_command *i = (struct listen_command *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class listen_command_class =
{ STATIC_HEADER,
  &command_class, "listen_command", sizeof(struct listen_command),
  do_listen_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_command_callback
{
  struct fd_listen_callback super;
  struct command_continuation *c;
};
extern struct lsh_class listen_command_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_command_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_command_callback *i = (struct listen_command_callback *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class listen_command_callback_class =
{ STATIC_HEADER,
  &fd_listen_callback_class, "listen_command_callback", sizeof(struct listen_command_callback),
  do_listen_command_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

