#ifndef GABA_DEFINE
struct tcpip_channel
{
  struct ssh_channel super;
  struct io_fd *socket;
};
extern struct lsh_class tcpip_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_channel *i = (struct tcpip_channel *) o;
  mark((struct lsh_object *) i->socket);
}

struct lsh_class tcpip_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "tcpip_channel", sizeof(struct tcpip_channel),
  do_tcpip_channel_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct tcpip_connected
{
  struct fd_callback super;
  struct tcpip_channel *channel;
  struct io_backend *backend;
  UINT32 block_size;
  struct channel_open_callback *response;
};
extern struct lsh_class tcpip_connected_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_tcpip_connected_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct tcpip_connected *i = (struct tcpip_connected *) o;
  mark((struct lsh_object *) i->channel);
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->response);
}

struct lsh_class tcpip_connected_class =
{ STATIC_HEADER,
  &fd_callback_class, "tcpip_connected", sizeof(struct tcpip_connected),
  do_tcpip_connected_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct open_direct_tcpip
{
  struct channel_open super;
  struct io_backend *backend;
};
extern struct lsh_class open_direct_tcpip_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_open_direct_tcpip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_direct_tcpip *i = (struct open_direct_tcpip *) o;
  mark((struct lsh_object *) i->backend);
}

struct lsh_class open_direct_tcpip_class =
{ STATIC_HEADER,
  &channel_open_class, "open_direct_tcpip", sizeof(struct open_direct_tcpip),
  do_open_direct_tcpip_mark,
  NULL
};
#endif /* !GABA_DECLARE */

struct lsh_object *tcpforward_foo(void)
{
#define A GABA_APPLY
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
  return
    S2(S2(K1(S), S2(K1(S1(K1(COMMAND_UNIMPLEMENTED))), S2(K1(S1(COMMAND_UNIMPLEMENTED)), K))), S2(K1(K), COMMAND_UNIMPLEMENTED));
#undef A
#undef S
#undef S1
#undef S2
#undef K
#undef K1
}
