; -*- Scheme -*-
;
; $Id: bawkt00.scm,v 1.1 1998/03/16 07:57:38 foner Exp $
;
; A simple BAWK example.
;
; When loaded, this looks for duplicate words in the file "bawk.dat"
; and displays the line number of any duplicate words found together
; with the word.  It is a simple example so it doesn't deal with
; puncuation, upper/lower-case ... etc., but it does deal with the
; case where duplicate words are broken across a line.

(require 'bawk:file)

(define last-word "")

(define display-equals
  (lambda (a b)
    (if (string=? a b)
	(begin
	  (display bawk:NR)
	  (display " ")
	  (display a)
	  (newline)))))

(define dups
  (lambda ()
    (let ((n (bawk:NF)))
      (if (not (zero? n))
	  (display-equals last-word (bawk:$ 1)))
      (let loop ((i 2))
	(if (<= i n)
	    (begin
	      (display-equals (bawk:$ (- i 1)) (bawk:$ i))
	      (loop (+ i 1)))
	    (set! last-word (bawk:$ n)))))))

(bawk:file "bawk.dat" dups)
