; -*- Scheme -*-
;
; $Id: char-set-08.scm,v 1.1 1998/03/16 07:57:48 foner Exp $

;------------

(require 'char-set::vector-size)
(require 'char-set::size!)

;+doc
; procedure: char-set:make
; arguments: none
; signature: unit -> char-set
;
; Create a new empty char-set
;-doc

(define char-set:make
  (lambda ()
    (let ((r (make-vector char-set::vector-size)))
      (let loop ((i (- char-set::vector-size 1)))
	(if (zero? i)
	    (begin (char-set::size! r 0) r)
	    (begin (vector-set! r i #f) (loop (- i 1))))))))

; eof
