1;;;; Counter macros.

;;; Counters are really parameters, but we never let the user touch them.
;;; We only increment them.

;;; Create a counter.
(defmacro def-yenta-counter (name human-name doc-string)
  `(def-yenta-param 
     ,name 
     0
     ,human-name 
     ,doc-string
     vars:->nonneg-number
     (counter)))
  
;;; Current value of the counter, accessed by name.
;;; An abstraction that is no longer necessary.  Use it or ignore it.
(defmacro counter:current (name)
  `,name)

;;; Increment the counter by any positive integer.  Will actually
;;; increment any variable, if allowed.  If you just need to increment
;;; by 1, it's shorter and easier to understand to just use inc!,
;;; which is defined in yenta-utils.
(defmacro counter:increment-by! (name inc)
  `(let ((amt ,inc))
     (cond ((<= amt 0)
	  (logger:log-and-display 1 "Attempt to increment counter ~S by non-positive value ~S" ',name amt))
	 (t
	  (set! ,name (+ amt ,name))))))

(defmacro counter:increment-by-zero-okay! (name inc) ; Sometimes this makes sense, like in a network conn that gets rejected w/no bytes sent.
  `(let ((amt ,inc))
     (cond ((< amt 0)
	  (logger:log-and-display 1 "Attempt to increment counter ~S by negative value ~S" ',name amt))
	 (t
	  (set! ,name (+ amt ,name))))))

;;; End of file.
