#! /usr/local/bin/perl
# -*-Perl-*-

# This forges mail to Majordomo asking to add a new user to one of our mailing lists.
# It would be more elegant if SCM actually sent this mail, but hey, we've already
# got this infrastructure.  Maybe later I'll write a simple SMTP client in Scheme;
# that would save some process invocation and some dependency on Perl.  Anybody
# wanna volunteer?

# The first arg is the name of the list to subscribe to (name only, e.g.,
# "yenta-announce").  The second arg is the email address that asked to be
# subscribed.  This does -no- checking to make sure things are kosher!
# Do that on the Scheme side, and be careful.

$listname = shift @ARGV;
$email =  shift @ARGV;

($listname) || die("No listname!\n");
($email) || die("No email!\n");

$MAILER = "/usr/lib/sendmail -t";

sub mail_notification {
    open(MAIL, "| $MAILER");
    print MAIL "To: majordomo@media.mit.edu\n";
    # The From: here is basically so I can review what's been going on if something blows up...
    print MAIL "From: yenta-autoreg@media.mit.edu\n";
    print MAIL "\n";
    print MAIL "\nsubscribe $listname $email\n";
    close(MAIL);
}

&mail_notification();
