(define (read-message:headers)
  (let* ((message (messages:get-message (string->number ui:index)))
	 (resp-to (messages:response-to message))
	 (recip (messages:recipient message))
	 (follow-ups (messages:responses message)))
    (format-debug 0 "~&~S~&" message)
    (list
     (if recip
	 "<b>Personal message</b><br>"
	 '())
     (if (messages:local-interest message)
	 (list
	  "<b>Relevant interest</b>: <a href = \"interests-contact.html?"
	  (messages:local-interest message)
	  "\">"
	  (interests:description (messages:local-interest message)))
	 '())
     "</a><br><b>Topic</b>: <i>"
     (compare:show-document (compare:import-document 
			     (messages:topic message)) 5)
     "</i><br><b>Sender</b>: <a href = \"identity.html?"
     (ui:bytes->hex (messages:sender message))
     "\">"
     (identity:description (messages:sender message))
     "</a>"
     (if resp-to
	 (list
	  "<br><b>In response to</b> "
	  (if (identity:index-of-message resp-to)
	      (list "<a href = \"read-message.html?"
		    (identity:index-of-message resp-to))
	      (list "<a href = \"message-missing.html?sender="
		    (ui:bytes->hex (car resp-to))
		    "&number="
		    (cadr resp-to)))
	  "\">a message</a> by <a href = \"identity.html?"
	  (ui:bytes->hex (car resp-to))
	  "\">"
	  (identity:description (car resp-to))
	  "</a>")
	 '())
     (if (null? follow-ups)
	 '()
	 (cons "<br><b>Responses from:</b>"
	       (ui:pretty-html-exp-list
		(map (lambda (item)
		       `("<a href = \"read-message.html?"
			 ,(identity:index-of-message item)
			 "\">"
			 ,(identity:description (car item))
			 "</a>"))
		     follow-ups))))
     "<br><b>Title</b>: "
     (ui:literal (messages:title message))
     "<hr>"
     (ui:literal (messages:text message))
     "<hr>"
     )))

(define (read-message:recip-form-entry)
  (if (messages:recipient (messages:get-message (string->number ui:index)))
      "<input type = \"hidden\" name = \"recipients\" value = \"individual\">"
      "<p><input type = \"radio\" name = \"recipients\" value = \"individual\" checked>to sender only
       <p><input type = \"radio\" name = \"recipients\" value = \"cluster\">to sender and all other recipients"))
