(yreq "Affordances/attestations-filter")
(yreq "UI/scheme-to-html")

;;; I'm really not incredibly happy having Yenta call out to a random URL elsewhere
;;; (and about having to support this URL as long as relevant releases exist), but
;;; this is such a marginal case that it doesn't seem worth making every single
;;; Yenta binary 152K bigger just to hold these pages.  Perhaps if we stored pages
;;; gzipped, I might feel differently; then it'd only be 34K.
(define *af:regexp-doc-url* "http://yenta.www.media.mit.edu/projects/Yenta/Releases/Documentation/regex-0.12/")

(define (af:verify-regexp)
  (if (and (ui:from-form?)
	   (ui:form-datum "check")
	   (ui:form-datum "check-string"))
      (if (regmatch? (ui:form-datum "check") (ui:form-datum "check-string"))
	  (list "<h3>" (ui:form-datum "check") " has passed " (ui:form-datum "check-string") " and will be an acceptable regular expression.</h3>")
	  (format nil "<h3>I cannot accept ~S as a valid regular expression.~&~
                  You may want to read <a href=\"~A\">this documentation</a> about regular expressions.</h3>" 
		  (ui:form-datum "check")
		  *af:regexp-doc-url*))
      '()))

(define (af:check)
  (if (and (ui:from-form?)
	   (ui:form-datum "check")
	   (ui:form-datum "check-string"))
      (ui:form-datum "check")
      '()))

(define (af:check-string)
  (if (and (ui:from-form?)
	   (ui:form-datum "check")
	   (ui:form-datum "check-string"))
      (ui:form-datum "check-string")
      '()))

(define (af:accept)
  (if (and (ui:from-form?)
	   (ui:form-datum "check")
	   (ui:form-datum "check-string")
	   (regmatch? (ui:form-datum "check") 
		      (ui:form-datum "check-string")))
      (list "<h3> Shall I add " (ui:form-datum "check") " to the filter list of acceptable regular expressions?</h3>
<p><form action = \"regfilter.html\" method = \"post\"></p>
<input type = \"hidden\" name = \"accept\" value = \"" (ui:form-datum "check") "\"> <input type = \"submit\" value = \"Accept\"> </form>")
      '()))

(define (af:add-regexp)
  (if (and (ui:from-form?)
	   (ui:form-datum "accept"))
      (af:regexp! (ui:form-datum "accept"))
     '()))
      
(define (af:update-accepted-regexp)
  (set! *af:regexp-new* #f)
  (when (and (ui:from-form?)
	     (equal? (number->string *af:regexp-seq-num*)
		     (ui:form-datum "seq-num")))
    (set! *yenta-accept* (ui:remove-checked *yenta-accept*)))
  '())

(define (af:new-seq-num)
  (inc! *af:regexp-seq-num*)
  *af:regexp-seq-num*)

(define (af:show-accepted-regexp)
  (let ((item-num -1)
	(results '()))
    (map (lambda (rec)
	   (inc! item-num)
	   (push! (format nil "<li><input type = \"checkbox\" name = \"item-~A\">&nbsp;~A"
			  item-num rec)
		  results))
	 *yenta-accept*)
    results))

(define (af:show-currently-accepted)
  (af:update-accepted-regexp)
  (let ((accepted (af:show-accepted-regexp)))
    (cond ((null? accepted)
	   "<b>[You have not defined any regular expressions.]</b><p>")
	  (t
	   (format nil "<h1>Currently accepted expressions</h1>~2&~
                        Check the box beside the expression and I'll know to remove that expression from accepted messages.<p>~&~
                        <form action = \"regfilter.html\" method = \"post\">
                          <input type = \"hidden\" name = \"seq-num\" value = \"~A\">
                          <ul>
                            ~A
                          </ul>
                          <input type = \"submit\" value = \"Remove checked expressions\">
                        </form>"
		   (af:new-seq-num)
		   (join-strings accepted "\n"))))))
