#include <stdio.h>
#include "shs/shs.h"
#include "md5/md5.h"
#include "rc4/rc4.h"
#include "include/cw.h"
void hash(CW_OPTS *opts, char *buf, char byte);
int parseopts(int, char **, CW_OPTS *);
void help(void);
void keysetup(CW_OPTS *opts, rc4_key *key);

int main (int argc, char **argv)
{
	CW_OPTS opts;
	char buffer[1024];
	char inhash[1024];
	char byte,bak;
	rc4_key rc4key;
	
        if ( parseopts(argc, argv, &opts) )
                return 0; 

	opts.seq = 1;

        if (opts.passphrase[0]==0)
        {
                fprintf(stderr,"Requires passphrase.\n");
                help();
                return 0;
        }
	
	if ( opts.crypto == '4' )
		keysetup(&opts, &rc4key);

	while ( fread(&byte, 1, 1, stdin) )
	{		
		fread(inhash, 1, opts.hashsize, stdin);
		hash(&opts, buffer, byte);
		if ( !memcmp(inhash, buffer, opts.hashsize) )
		{
			if ( opts.crypto == '4' )
				rc4(&byte, 1, &rc4key);
			fwrite(&byte, 1,1,stdout);
			opts.seq++;
		}

	}
}
void hash(CW_OPTS *opts, char *buf, char byte)
{
	SHS_INFO shsInfo;
	MD5_CTX md5Info;
	char buffer[1024];
	buffer[0]=byte;
	memcpy(buffer+1, opts->passphrase, opts->passlen);
	memcpy(buffer+1+opts->passlen, &opts->seq, sizeof(long));
	if ( opts->hash_function=='s' )
	{
		shsInit(&shsInfo);
		shsUpdate(&shsInfo, buffer, opts->passlen+1+sizeof(long));
		shsFinal(&shsInfo);
		memcpy(buf,shsInfo.digest, 20);
	} else {
		MD5Init(&md5Info);
		MD5Update(&md5Info, buffer, opts->passlen+1+sizeof(long));
		MD5Final(&md5Info);
		memcpy(buf,md5Info.digest, 16);
	}
}
void help(void)
{
        fprintf(stderr,"Valid options:\n");
        fprintf(stderr,"     -hN             selects hash to use (s = SHA,5 = MD5). Default: SHA\n");
        fprintf(stderr,"     -cN             selects encryption algorithm(4 = RC4)\n");
        fprintf(stderr,"     -a phrase       Defines passphrase when using valid MACs\n");
        fprintf(stderr,"     -f filename     Defines the input file to use.\n");
        fprintf(stderr,"                     Default: none.\n");
        fprintf(stderr,"     Input is from stdin or a file, Output is always stdout.\n\n");
        fprintf(stderr,"Example: wino -hs -a password -f secret.field > secret.txt \n");
        fprintf(stderr,"This will use SHA  with 'password' as the MAC phrase.\n");
        fprintf(stderr,"secret.txt  will get decoded from secret.field\n");
 }
int parseopts(int argc, char **argv, CW_OPTS *opts)
{
        int i;

        opts->hash_function='s';
        opts->crypto='0';
        strcpy(opts->randpath, "/dev/urandom");
        strcpy(opts->filename, "");

        for (i=1; i<=argc-1; i++)
        {
                if ( argv[i][0]=='-' )
                {
                        switch (argv[i][1])
                        {
                                case 'h':
                                        if ( (argv[i][2]=='s') || (argv[i][2]=='5') )
					opts->hash_function=argv[i][2];
                                        break;
                                case 'c':
                                        if ( (argv[i][2]=='4') )
                                                opts->crypto=argv[i][2];
                                        break;
                                case 'a':
					strcpy(opts->passphrase,argv[i+1]);
					opts->passlen=strlen(opts->passphrase);
                                        break;
                                case 'f':
                                        strcpy(opts->filename,argv[i+1]);
                                        break;
                                default:
                                        fprintf(stderr,"Bad option: %s\n",argv[i]);
                                        help();
                                        return -1;
                        }
                }
        }
        if (opts->hash_function=='s')
                opts->hashsize=20;
        if (opts->hash_function=='5')
                opts->hashsize=16;
        return 0;                           
}
void keysetup(CW_OPTS *opts, rc4_key *key)
{
        unsigned char p[1024];
        int i;
        SHS_INFO shsInfo; /* data for SHA */
        memcpy(p, opts->passphrase, opts->passlen);
        i=opts->passlen;
        shsInit(&shsInfo);
        shsUpdate(&shsInfo, p, i);
        memcpy(opts->passphrase, &shsInfo, 16);
        shsUpdate(&shsInfo, opts->passphrase, 16);
        memcpy(p, &shsInfo, 16);
        prepare_key((unsigned char *)p,16,key);
}   
