/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * $Id: ipsec_radij.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_radij.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * Definitions relevant to the IPSEC <> radij tree interfacing
 */

int ipsec_walk(char *);
struct eroute * ipsec_makeroute(struct sockaddr_encap *ea, struct sockaddr_encap *em, struct in_addr ed, u_long spi);
int ipsec_radijinit(void);

struct eroute * ipsec_findroute(struct sockaddr_encap *);
int ipsec_delroute(struct sockaddr_encap *eaddr, struct sockaddr_encap *emask);

#define O1(x) (int)(((x)>>24)&0xff)
#define O2(x) (int)(((x)>>16)&0xff)
#define O3(x) (int)(((x)>>8)&0xff)
#define O4(x) (int)(((x))&0xff)

#ifdef DEBUG_IPSEC_RADIJ

extern int debug_radij;
void rj_dumptrees(void);

#define DB_RJ_DUMPTREES	0x0001
#define DB_RJ_FINDROUTE 0x0002

#endif
