/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_encap.h,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_encap.h,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * Minor cosmetic changes.
 *
 * Revision 0.3  1996/11/20 14:35:48  ji
 * Minor Cleanup.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

/*
 * Declarations relevant to encapsulation-like operations.
 */

struct sockaddr_encap
{
	__u8	sen_len;		/* length */
	__u8	sen_family;		/* AF_ENCAP */
	__u16	sen_type;		/* see SENT_* */
	union
	{
		struct			/* SENT_IP4 */
		{
			struct in_addr Src;
			struct in_addr Dst;
		} Sip4;
	} Sen;
};

#define sen_ip_src	Sen.Sip4.Src
#define sen_ip_dst	Sen.Sip4.Dst

/*
 * The "type" is really part of the address as far as the routing
 * system is concerned. By using only one bit in the type field
 * for each type, we sort-of make sure that different types of
 * encapsulation addresses won't be matched against the wrong type.
 * 
 */

#define SENT_IP4	0x0008		/* data is two struct in_addr */

#define SEN_HDRLEN	(2*sizeof(__u8)+sizeof(__u16))

#define SEN_IP4_SRCOFF	(0)
#define SEN_IP4_DSTOFF (sizeof (struct in_addr))
#define SEN_IP4_OPTOFF	(2 * sizeof (struct in_addr))

#define SEN_IP4_LEN	(SENT_HDRLEN + SENT_IP4_OPTOFF)


/*
 * An entry in the radix tree 
 */

struct rjtentry
{
	struct	radij_node rd_nodes[2];	/* tree glue, and other values */
#define	rd_key(r)	((struct sockaddr_encap *)((r)->rd_nodes->rj_key))
#define	rd_mask(r)	((struct sockaddr_encap *)((r)->rd_nodes->rj_mask))
	short	rd_flags;
	short	rd_count;
};

/*
 * An encapsulation route consists of a pointer to a 
 * radix tree entry and a SAID (a destination address/SPI pair).
 */

struct eroute
{
	struct rjtentry er_rjt;
	struct in_addr	er_dst;	/* XXX should it be sockaddr? */
	__u32		er_spi;
	struct sockaddr_encap er_eaddr;
	struct sockaddr_encap er_emask;
};

#ifdef DEBUG_IPSEC_EROUTE

extern int debug_eroute;

#define DB_ER_PROCFS	0x0001

#endif

#ifdef DEBUG_IPSEC_SPI

extern int debug_spi;

#define DB_SP_PROCFS	0x0001

#endif

