/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <netdb.h>
#include <unistd.h>
#include "constants.h"
#include "state.h"
#include "defs.h"

/*
 * Initialize the kernel socket.
 * XXX For now, just get a port.
 */
int
init_kernelfd(void)
{
    struct sockaddr_in sin;
    int s;
    
    s = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (s == -1)
      exit_log("socket() in init_kernelfd()", 0, 0, 0);
    
    sin.sin_family = AF_INET;
    sin.sin_port = htons(our_port + 1);
    sin.sin_addr.s_addr = INADDR_ANY;

#ifdef DEBUG
    log(0, "init_kernelfd(): listening to port %d", our_port + 1, 0, 0);
#endif

    if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
      exit_log("bind() in init_kernelfd()", 0, 0, 0);
   
    return s;
}

/*
 * Initialize the main send/receive socket
 */
int
init_socket(void)
{
    struct protoent *proto;
    struct sockaddr_in sin;
    int sock, i, j, k;
    
    /* Get a UDP socket */

    proto = getprotobyname("udp");
    
    if (proto == (struct protoent *) NULL)
      sock = socket(PF_INET, SOCK_DGRAM, 0);
    else
      sock = socket(PF_INET, SOCK_DGRAM, proto->p_proto);
    
    if (sock == -1)
      exit_log("socket() failed in init_socket()", 0, 0, 0);

    sin.sin_family = AF_INET;
    sin.sin_port = htons(our_port);
    sin.sin_addr.s_addr = INADDR_ANY;

#ifdef DEBUG
    log(0, "init_socket(): listening to port %d", our_port, 0, 0);
#endif

    /* bind the socket */
    if (bind(sock, (struct sockaddr *)&sin, sizeof(sin)) < 0)
      exit_log("bind() failed in init_socket()", 0, 0, 0);

    /* Maximize send and receive socket buffers */

    j = sizeof(i);
    
    if (getsockopt(sock, SOL_SOCKET, SO_SNDBUF, &i, &j) != -1)
    {
	k = 4096;
	
	for (i += k; k > 0; i += k)
	  if (setsockopt(sock, SOL_SOCKET, SO_SNDBUF, &i, j) == -1)
	  {
	      i -= k;
	      k /= 2;
	  }
    }
    else
      log(1, "getsockopt() failed in init_socket()", 0, 0, 0);
    
    j = sizeof(i);

    if (getsockopt(sock, SOL_SOCKET, SO_RCVBUF, &i, &j) != -1)
    {
	k = 4096;
	
	for (i += k; k > 0; i += k)
	  if (setsockopt(sock, SOL_SOCKET, SO_RCVBUF, &i, j) == -1)
	  {
	      i -= k;
	      k /= 2;
	  }
    }
    else
      log(1, "getsockopt() failed in init_socket()", 0, 0, 0);
    
    return sock;
}

/*
 * This routine listens for incoming ISAKMP packets, kernel PF_KEY requests,
 * handles packet retransmitts and other events.
 */
void
call_server(void)
{
    struct sockaddr_in sin;
    int kernelfd;
    int sock;
    fd_set readfds;
    struct timeval tm;
    int i, maxfd;
    
    sock = init_socket();
    kernelfd = init_kernelfd();
    
    while (1)
    {
	FD_SET(sock, &readfds);
	FD_SET(kernelfd, &readfds);

	maxfd = (sock > kernelfd ? sock : kernelfd) + 1;

	i = next_event();   /* Is there any pending event ? */
	if (i == -1)
	  i = select(maxfd, &readfds, NULL, NULL, NULL);
	else
	{
	    tm.tv_sec = i;
	    tm.tv_usec = 0;
	    i = select(maxfd, &readfds, NULL, NULL, &tm);
	}

	if (i == -1)
	  exit_log("select() failed in call_server()", 0, 0, 0);

	if (FD_ISSET(sock, &readfds))
#ifdef DEBUG
	{
	    log(0, "received packet", 0, 0, 0);
#endif
	  comm_handle(kernelfd, sock);
#ifdef DEBUG
	}
#endif

	if (FD_ISSET(kernelfd, &readfds))
#ifdef DEBUG
	{
	    log(0, "received kernel message", 0, 0, 0);
#endif
	  kernel_handle(kernelfd, sock);
#ifdef DEBUG
	}
#endif
	
	if (i == 0)   /* Event */
#ifdef DEBUG
	{
	    log(0, "time to handle event", 0, 0, 0);
#endif
	  event_handle(kernelfd, sock);
#ifdef DEBUG	    
	}
#endif
    }
}
