/*	IDEA Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/
#ifndef __MYIDEA_HPP
#define __MYIDEA_HPP

// Only 52 of the 56 subkeys used
typedef struct
{
	unsigned short Key[8];				// Key
	char *StrKey;						// String Key
	unsigned short SubKeys[56];			// Encryption Subkeys
	unsigned short DCSubKeys[56];		// Decryption Subkeys
	unsigned short LastBlock[4];		// For CBC Encrypt
	unsigned short LastBlockDC[4];		// For CBC Decrypt
	unsigned int Flags;
} IDEAKeys;

#define IDEA_CBC	1

void IDEA_SetKey(IDEAKeys *Keys, char *key);
void IDEA_SetCBC(IDEAKeys *Keys, int t);
void IDEA_InitKeys(IDEAKeys *Keys);
void IDEA_ShutdownKeys(IDEAKeys *Keys);
void IDEA_GenSubKeys(IDEAKeys * Keys);
unsigned short IDEA_MulInv(unsigned short x);
unsigned short IDEA_MulMod(unsigned short a,unsigned short b);
void IDEA_EncryptBlocks(IDEAKeys *Keys, unsigned short *s_data, int numquads);
void IDEA_DecryptBlocks(IDEAKeys *Keys, unsigned short *s_data, int numquads);

#endif // __MYIDEA_HPP
