//
// bmath.asm
//
// Leonard Janke
// August 1996

inline int BMath::BSR(unsigned int x)
{
  int bitNum;
  asm("bsrl %1, %0\n\t"
      : "=r" (bitNum)
      : "rm" (x)
      );
  return bitNum;
}

inline char BMath::GreaterThanOrEqualTo(const unsigned int* A, 
					const unsigned int* B, 
					const int size)
{
  char result;
  asm("cld\n\t"
      "repe\n\t"
      "cmpsl (%%esi), (%%edi)\n\t"
      "setaeb %%al\n\t"
      : "=al" (result)
      : "S" (A), "D" (B), "ecx" (size)
      : "%esi", "%edi", "%ecx"
      );
  return result;
}

inline void BMath::BasicAdd(const unsigned int* A, const unsigned int* B, 
			    unsigned int* C, const int size, char& carry)
{
  asm volatile("clc\n\t"
	       "decl %%ecx\n\t"
	       ""
	       "0:\tmovl (%%esi,%%ecx,4), %%eax\n\t"
	       "adcl (%%ebx,%%ecx,4), %%eax\n\t"
	       "movl %%eax, (%%edi,%%ecx,4)\n\t"
	       "decl %%ecx\n\t"
	       "jns 0b\n\t"
	       "setcb %0\n\t"
	       : "=rm" (carry) 
	       : "S" (A), "D" (C), "ebx" (B), "ecx" (size) 
	       : "%eax", "%ecx", "memory"
	       );
}

inline void BMath::RippleAdd(const unsigned int* A, const unsigned int* B, 
			     unsigned int* C, const int size)
{
  asm volatile("decl %%ecx\n\t"
	       ""
	       "0:\tmovl (%%esi,%%ecx,4), %%eax\n\t"
	       "adcl (%%ebx,%%ecx,4), %%eax\n\t"
	       "movl %%eax, (%%edi,%%ecx,4)\n\t"
	       "decl %%ecx\n\t"
	       "jns 0b\n\t"
	       "jnc 2f\n\t"
               "1:\tadcl $0, (%%edi,%%ecx,4)\n\t"
               "decl %%ecx\n\t"
               "jc 1b\n\t"
	       "2:\t\n"
	       : 
	       : "S" (A), "D" (C), "ebx" (B), "ecx" (size) 
	       : "%eax", "%ecx", "memory"
	       );
}


inline void BMath::BasicSubtract(const unsigned int* A, const unsigned int* B,
				 unsigned int* C, const int size, 
				 char& borrow)
{
  asm volatile("clc\n\t"
	       "decl %%ecx\n\t"
	       "" 
	       "0:\tmovl (%%esi,%%ecx,4), %%eax\n\t"
	       "sbbl (%%edx,%%ecx,4), %%eax\n\t"
	       "movl %%eax, (%%ebx,%%ecx,4)\n\t"
	       "decl %%ecx\n\t"
	       "jns 0b\n\t"
	       "setcb %0\n\t"
	       : "=rm" (borrow) 
	       : "S" (A), "edx" (B), "ebx" (C), "ecx" (size)
	       : "%eax", "%ecx", "memory" 
	       );
}

inline void BMath::RippleSubtract(const unsigned int* A, const unsigned int* B,
				  unsigned int* C, const int size)
{
  asm volatile("clc\n\t"
	       "decl %%ecx\n\t"
	       "" 
	       "0:\tmovl (%%esi,%%ecx,4), %%eax\n\t"
	       "sbbl (%%edx,%%ecx,4), %%eax\n\t"
	       "movl %%eax, (%%ebx,%%ecx,4)\n\t"
	       "decl %%ecx\n\t"
	       "jns 0b\n\t"
	       "jnc 2f\n\t"
               "1:\tsbbl $0, (%%ebx,%%ecx,4)\n\t"
               "decl %%ecx\n\t"
               "jc 1b\n\t"
	       "2:\t\n"
	       :
	       : "S" (A), "edx" (B), "ebx" (C), "ecx" (size)
	       : "%eax", "%ecx", "memory" 
	       );
}

inline void BMath::RippleIncrement(unsigned int* linteger, const int size)
{
  asm volatile("0:\tdecl %%ecx\n\t"
	       "addl $1, (%%edi,%%ecx,4)\n\t"
	       "jc 0b\n\t"
	       :
	       : "ecx" (size), "D" (linteger)
	       : "%ecx", "memory"
	       );
}

inline void BMath::Increment(unsigned int* linteger, int size,
			     char& carry)
{
  asm volatile("decl %%ecx\n\t"
               "0:\taddl $1, (%%edi,%%ecx,4)\n\t"
               "jnc 1f\n\t"
               "decl %%ecx\n\t"
               "jns 0b\n\t"
               "1:\tsetcb %0\n\t"
               : "=rm" (carry)
               : "ecx" (size), "D" (linteger)
               : "%ecx", "memory"
               );
}

inline void BMath::RippleDecrement(unsigned int* linteger, const int size)
{
  asm volatile("0:\tdecl %%ecx\n\t"
	       "subl $1, (%%edi,%%ecx,4)\n\t"
	       "jc 0b\n\t"
	       : 
	       : "ecx" (size), "D" (linteger)
	       : "%ecx", "memory"
	       );
}

inline void BMath::BasicMultiply(const unsigned int* A, unsigned int B,
				 unsigned int* C, const int sizeA)
{
  asm volatile("0:\tcmpl $0, %%ecx\n\t"
               "je 2f\n\t"
               "movl %%ebx, %%eax\n\t"
               "mull (%%esi,%%ecx,4)\n\t"
               "addl %%eax, (%%edi,%%ecx,4)\n\t"
               "decl %%ecx\n\t"
               "adcl %%edx, (%%edi,%%ecx,4)\n\t"
               "jnc 0b\n\t"
               ""
               "pushl %%ecx\n\t"
               "1:\tdecl %%ecx\n\t"
               "adcl $0, (%%edi,%%ecx,4)\n\t"
               "jc 1b\n\t"
               "popl %%ecx\n\t"
               "jmp 0b\n\t"
               ""
               "2:\t"
               :
               : "S" (A-1), "D" (C), "ebx" (B), "ecx" (sizeA)
               : "%eax", "%edx", "%ecx", "memory"
               );
}

inline void BMath::MultDouble(unsigned int* productBuf, const unsigned int* a, 
			      const unsigned int* b)
{
  asm volatile("movl $0, %%ecx\n\t"
	       "movl 4(%%esi), %%eax\n\t"
	       "mull 4(%%ebx)\n\t"
	       "movl %%eax, 12(%%edi)\n\t"
	       "movl %%edx, 8(%%edi)\n\t"
	       "addl %%eax, 8(%%edi)\n\t"
	       "adcl $0, %%edx\n\t"
	       "movl %%edx, 4(%%edi)\n\t"
	       "movl $0, %%edx\n\t"
	       "adcl $0, %%edx\n\t"
	       "movl %%edx, (%%edi)\n\t"
	       "movl (%%esi), %%eax\n\t"
	       "mull (%%ebx)\n\t"
	       "addl %%eax, 4(%%edi)\n\t"
	       "adcl %%edx, (%%edi)\n\t"
	       "addl %%eax, 8(%%edi)\n\t"
	       "adcl %%edx, 4(%%edi)\n\t"
	       "adcl $0, (%%edi)\n\t"
	       "movl (%%esi), %%eax\n\t"
	       "subl 4(%%esi), %%eax\n\t"
	       "jae 1f\n\t"
	       "negl %%eax\n\t"
	       "movl $1, %%ecx\n\t"
	       "1:\tmovl 4(%%ebx), %%edx\n\t"
	       "subl (%%ebx), %%edx\n\t"
	       "jae 2f\n\t"
	       "negl %%edx\n\t"
	       "xorl $1, %%ecx\n\t"
	       "2:\tmull %%edx\n\t"
	       "jecxz 3f\n\t"
	       "subl %%eax, 8(%%edi)\n\t"
	       "sbbl %%edx, 4(%%edi)\n\t"
	       "sbbl $0, (%%edi)\n\t"
	       "jmp 4f\n\t"
	       "3:\taddl %%eax, 8(%%edi)\n\t"
	       "adcl %%edx, 4(%%edi)\n\t"
	       "adcl $0, (%%edi)\n\t"
	       "4:\t\n"
	       : 
	       : "D" (productBuf), "S" (a), "ebx" (b)
	       : "eax", "edx", "ecx", "memory"
	       );
}

inline void BMath::SquareDouble(unsigned int* productBuf, const unsigned int* a)
{
  asm volatile("movl 4(%%esi), %%eax\n\t"
	       "mull %%eax\n\t"
	       "movl %%eax, 12(%%edi)\n\t"
	       "movl %%edx, 8(%%edi)\n\t"
	       "addl %%eax, 8(%%edi)\n\t"
	       "adcl $0, %%edx\n\t"
	       "movl %%edx, 4(%%edi)\n\t"
	       "movl $0, %%edx\n\t"
	       "adcl $0, %%edx\n\t"
	       "movl %%edx, (%%edi)\n\t"
	       "movl (%%esi), %%eax\n\t"
	       "mull %%eax\n\t"
	       "addl %%eax, 4(%%edi)\n\t"
	       "adcl %%edx, (%%edi)\n\t"
	       "addl %%eax, 8(%%edi)\n\t"
	       "adcl %%edx, 4(%%edi)\n\t"
	       "adcl $0, (%%edi)\n\t"
	       "movl (%%esi), %%eax\n\t"
	       "subl 4(%%esi), %%eax\n\t"
	       "jae 0f\n\t"
	       "negl %%eax\n\t"
	       "0:\tmull %%eax\n\t"
	       "subl %%eax, 8(%%edi)\n\t"
	       "sbbl %%edx, 4(%%edi)\n\t"
	       "sbbl $0, (%%edi)\n\t"
	       : 
	       : "D" (productBuf), "S" (a)
	       : "eax", "edx",  "memory"
	       );
}

inline void BMath::BasicDivide(unsigned int dividendHigh, 
			       unsigned int dividendLow,
			       unsigned int divisor,
			       unsigned int& quotient,
			       unsigned int& remainder)
{
  asm("divl %4\n\t"
      : "=eax" (quotient), "=edx" (remainder)
      : "edx" (dividendHigh), "eax" (dividendLow), "rm" (divisor)
      );
}

inline void BMath::ShiftLeft(unsigned int* buf, int size,
			     char distance)
{
  asm volatile("movl $0, %%eax\n\t"
               "decl %%edx\n\t"
               ""
               "0:\tmovl (%%esi,%%edx,4), %%ebx\n\t"
               "shldl %%cl, %%eax, (%%esi,%%edx,4)\n\t"
               "movl %%ebx, %%eax\n\t"
               "decl %%edx\n\t"
               "jns 0b\n\t"
               :
               : "S" (buf), "edx" (size), "cl" (distance)
               : "%eax", "%ebx", "%edx", "memory"
               );
}

inline void BMath::ShiftRight(unsigned int* buf, int size,
			      char distance)
{
  asm volatile("movl $0, %%eax\n\t"
               "movl $0, %%edi\n\t"
               "0:\tmovl (%%esi,%%edi,4), %%ebx\n\t"
               "shrdl %%cl, %%eax, (%%esi,%%edi,4)\n\t"
               "movl %%ebx, %%eax\n\t"
               "incl %%edi\n\t"
               "cmpl %%edx, %%edi\n\t"
               "jne 0b\n\t"
               :
               : "S" (buf), "edx" (size), "cl" (distance)
               : "%eax", "%ebx", "%edi", "memory"
               );
}

inline char BMath::Normalize(unsigned int* buf, int size)
{
  char normalizationFactor;

  asm volatile("movl $31, %%cl\n\t"
               "bsrl (%%esi), %%al\n\t"
               "subb %%al, %%cl\n\t"
               "movl $0, %%eax\n\t"
               "decl %2\n\t"
               "0:\tmovl (%%esi,%2,4), %%ebx\n\t"
               "shldl %%cl, %%eax, (%%esi,%2,4)\n\t"
               "movl %%ebx, %%eax\n\t"
               "decl %2\n\t"
               "jns 0b\n\t"
               : "=cl" (normalizationFactor)
               : "S" (buf), "edx" (size)
               : "%eax", "%ebx", "%edx", "memory"
               );

  return normalizationFactor;
}

