//
// linteger.hxx
//
// Leonard Janke
// August 1996

#ifndef _LINTEGER_HXX
#define _LINTEGER_HXX

#include <iostream.h>
#include <iomanip.h>
#include <cassert>
#include "bmath.hxx"

class LInteger 
{
private:
  static inline LInteger Negative(const LInteger&);
  static inline LInteger AbsoluteValue(const LInteger&);
  static int CompareMagnitudes(const LInteger&, const LInteger&);

  static int compress(unsigned int*&, const int);
protected:
  unsigned int* _magnitude;
  int _sign;
  int _size;
public:
  LInteger();
  LInteger(const unsigned int*, const int, const int=0, const int=1);
  LInteger(const LInteger&);
  LInteger(const unsigned int, const int=0);
  LInteger(const int);
  LInteger& operator=(const LInteger&); 
  ~LInteger();

  inline int sign() const;
  inline void setSign(const int);
  inline int size() const;
  inline void setSize(const int);
  inline unsigned int* magnitude() const;

  friend inline LInteger operator-(const LInteger&);
  friend inline LInteger operator+(const LInteger&);

  friend LInteger operator+(const LInteger&, const LInteger&);
  inline LInteger& operator+=(const LInteger&);

  inline LInteger& operator++(int); // postfix
  inline LInteger& operator++();    // prefix

  friend inline LInteger operator-(const LInteger&, const LInteger&);
  inline LInteger& operator-=(const LInteger&);

  inline LInteger& operator--(int); // postfix 
  inline LInteger& operator--();    // prefix

  friend LInteger operator*(const LInteger&, const LInteger&);
  inline LInteger& operator*=(const LInteger&);

  friend LInteger operator/(const LInteger&, const LInteger&);
  inline LInteger& operator/=(const LInteger&);

  friend LInteger operator%(const LInteger&, const LInteger&);
  inline LInteger& operator%=(const LInteger&);

  friend LInteger operator^(const LInteger&, const LInteger&);
  inline LInteger& operator^=(const LInteger&);

  friend LInteger operator|(const LInteger&, const LInteger&);
  inline LInteger& operator|=(const LInteger&);

  friend LInteger operator&(const LInteger&, const LInteger&);
  inline LInteger& operator&=(const LInteger&);

  friend LInteger operator~(const LInteger&);

  friend LInteger operator>>(const LInteger&, const int);
  inline LInteger& operator>>=(const int);

  friend LInteger operator<<(const LInteger&, const int);
  inline LInteger& operator<<=(const int);

  friend inline int operator<(const LInteger&, const LInteger&);
  friend inline int operator>(const LInteger&, const LInteger&);
  friend inline int operator==(const LInteger&, const LInteger&);
  friend inline int operator!=(const LInteger&, const LInteger&);
  friend inline int operator<=(const LInteger&, const LInteger&);
  friend inline int operator>=(const LInteger&, const LInteger&);

  friend inline int operator!(const LInteger&);
  friend inline int operator&&(const LInteger&,const int);
  friend inline int operator&&(const int,const LInteger&);
  friend inline int operator||(const LInteger&,const int);
  friend inline int operator||(const int,const LInteger&);

  // Now the dangerous part... 
  inline operator int(); 
  
  inline int compressable() const;
  void compress();

  friend class LMath;
  friend class Monty;

  friend ostream& operator<<(ostream&, const LInteger&);
};     


#include "linteger.inl"

#endif
