/*
 *  SecuDE Release 4.3 (GMD)
 */
/********************************************************************
 * Copyright (C) 1994, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/


#ifndef MAC
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <stdlib.h>
#include <string.h>
#include "MacTypes.h"
#include "Mac.h"
#endif /* MAC */


#include <fcntl.h>
#include <stdio.h>
#include "af.h"

#define WMODE 0644

/***************************************************************
 *
 * Procedure aux_file2OctetString
 *
 ***************************************************************/
#ifdef __STDC__

OctetString *aux_file2OctetString(
	char	 *fn
)

#else

OctetString *aux_file2OctetString(
	fn
)
char	 *fn;

#endif

{
	extern int	errno;
	extern char     *sys_errlist[];
	int	fd = -1;
	struct stat statbuf;
	char	*buf;
	unsigned int	fsize = 0, rest, rpt, portion = 4096, current;
	OctetString * ostr; /* returned */
	char	*proc = "aux_file2OctetString";

	if (!(ostr = (OctetString * )malloc(sizeof(OctetString)))) {
		aux_add_error(EMALLOC, "ostr", CNULL, 0, proc);
		return(NULLOCTETSTRING);
	}
	ostr->noctets = 0;

	if ( !fn || !strlen(fn)) {
		fd = 0;
		rest = portion;
		if (!(buf = (char *)malloc(rest))) {
			aux_add_error(EMALLOC, "buf(1)", CNULL, 0, proc);
			free(ostr);
			return(NULLOCTETSTRING);
		}
	} 
	else {
		if ( stat(fn, &statbuf) == -1 ) {
			aux_add_error(ESYSTEM, sys_errlist[errno], (char *) fn, char_n, proc);
			free(ostr);
			return(NULLOCTETSTRING);
		}
		fsize = (unsigned int)statbuf.st_size;
		rest = fsize;
		if ( !(buf = (char *)malloc(fsize))) {
			aux_add_error(EMALLOC, "buf(2)", CNULL, 0, proc);
			free(ostr);
			return( NULLOCTETSTRING );
		}

	
#ifndef MS_DOS
		if((fd = open(fn, O_RDONLY)) < 0 ) {
#else
                if((fd = open(fn, O_RDONLY | O_BINARY)) < 0 ) {
#endif
			aux_add_error(ESYSTEM, "open failed", CNULL, 0, proc);
			free(ostr);
			free(buf);
			return( NULLOCTETSTRING );
		}
	}
	rpt = 0;
	while ((current = read(fd, buf + rpt, rest)) > 0) {
		if (fsize) {
			if (current == rest) {
				ostr->noctets = current;
				break;
			} 
			else {
				if (fd > 2) close(fd);
				return( NULLOCTETSTRING );
			}
		}
		rpt += current;
		ostr->noctets = rpt;
		if (current >= portion) 
			if (!(buf = (char *)realloc(buf, rpt + portion))) {
				aux_add_error(EMALLOC, "buf(3)", CNULL, 0, proc);
				return( NULLOCTETSTRING );
			}
	}

	/* realloc really used memory when reading from stdin */
	if(!fsize) {
		if(rpt) {
			if (!(buf = (char *)realloc(buf, rpt))) {
				aux_add_error(EMALLOC, "buf(3)", CNULL, 0, proc);
				return( NULLOCTETSTRING );
			}
		}
		else {
			free(buf);
			buf = CNULL;
		}
	}



	ostr->octets = buf;
	if (fd > 2) close(fd);
	return(ostr);
}


/***************************************************************
 *
 * Procedure aux_file2OctetString
 *
 ***************************************************************/
/*
   aux_OctetString2file writes fn from OctetString ostr;
   flag=0:      no overwrite (file must not exist),
       =1:      overwrite    (file must exist),
       =2:      create or overwrite,
       =3:      append       (file must exist),
       =4:      create or append,
       default: like flag=0;
   aux_OctetString2file returns 0 on success and -1 on error.
*/
#ifdef __STDC__


int	aux_OctetString2file	(
	OctetString 	*ostr,
	char 		*fn,
	int 		 flag
)

#else

int	aux_OctetString2file	(
	ostr,
	fn,
	flag
)
OctetString 	*ostr;
char 		*fn;
int 		 flag;

#endif

{
	extern int	errno;
	int	        fd = -1;
	struct stat     statbuf;
	long	        rest, wpt;
	int	        openflag;
	char	      * proc = "aux_OctetString2file";

	if ( !ostr ) {
		aux_add_error(EINVALID, "ostr empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !fn || !strlen(fn) ) 
		fd = 1;
	else {
		switch (flag) {
		case 0:
			openflag = O_CREAT | O_EXCL | O_WRONLY;
			break;
		case 1:
			openflag = O_TRUNC | O_WRONLY;
			break;
		case 2:
			openflag = O_CREAT | O_TRUNC | O_WRONLY;
			break;
		case 3:
			openflag = O_APPEND | O_WRONLY;
			break;
		case 4:
			openflag = O_CREAT | O_APPEND | O_WRONLY;
			break;
		}
#ifdef MS_DOS
                openflag = openflag | O_BINARY;
#endif
#ifdef MAC
 		if ((fd = open(fn, openflag)) < 0 ) 
#else
 		if ((fd = open(fn, openflag, WMODE)) < 0 ) 
#endif
			return(-1);
	}

	wpt = 0;
	rest = ostr->noctets;
	if(rest)
		while (((wpt = write(fd, ostr->octets + wpt, rest)) < rest) && wpt) {
			if (wpt < 0) {
				if (fd > 2) 
					close(fd);
				aux_add_error(ESYSTEM, "write failed", CNULL, 0, proc);
				return(-1);
			}
			rest = rest - wpt;
		}
	if (fd > 2) close(fd);
	return(0);
}


