/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"


static int headerfd = 1;	/* standard output for body data */

static int header_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(headerfd, buf));
}

static int error_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(2, buf));
}


main(argc, argv)
int	argc;
char	**argv;
{
    int r = NOTOK;
    struct cbstruct iocbs;
    char **user = NULLVP;
    char **localopts = NULLVP;
    char **sigalias = NULLVP;
    char **template = NULLVP;
    char **headeropt = NULLVP;
    char **chainopt = NULLVP;
    char *chaintype;
    char **av = NULLVP;
    FILE *headerfile = (FILE *)0;

    /*  Initialize TIS/PEM  */

    if (pem_init(argc, argv, &localopts) != OK) {
	(void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
	goto cleanup;
    }

    /* check arg count and provide help */

    if (argc > 1 && !strcasecmp(argv[1], "help")) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "%s %s %s\n%s\n",
		       "Usage:", myname, 
		       "[<tag> <value> ...] [chain-type certificate|crl|key]",
		       "       [header-out <filename>]");
	goto cleanup;
    }

    /* Process options */

    if ((headeropt =  tag_user(localopts, "header-out")) != NULLVP) {
	if ((headerfile = fopen(*(headeropt+1), "w")) == (FILE *)0) {
	    (void) fprintf(stderr, "%s: unable to open header-out file %s.\n", 
			   myname, *(headeropt+1));
	    goto cleanup;
	}
	headerfd = fileno(headerfile);
    }
	
    if ((chainopt = tag_user(localopts, "chain-type")) == NULLVP) 
	chaintype = add2cp(NULLCP, "certificate");
    else 
	chaintype = add2cp(NULLCP, *(chainopt+1));


    /* create a template by removing options */

    for (av = localopts; av != NULLVP && *av != NULLCP && *(av+1) != NULLCP;
	 av+= 2)
	if (strcasecmp(*av, "header-out") != 0 && 
	    strcasecmp (*av, "chain-type") != 0) {
	    template = add2av(template, *av);
	    template = add2av(template, *(av+1));
	}

    /* find first user based on template or sig-alias, if no template */

    if (template == NULLVP) {
	if ((sigalias = tag_user(user_tailor, "sig-alias")) == NULLVP) {
	    (void) fprintf(stderr, "%s: can't determine sig-alias.\n",
			   myname);
	    goto cleanup;
	}
	if ((user = get_tv_user("alias", *(sigalias+1))) == NULLVP) {
	    (void) fprintf(stderr, 
		   "%s: Unable to find user with sig-alias alias \"%s\".\n",
                           myname, *(sigalias+1));
            goto cleanup;
	}
    }
    else if ((user = get_tvt_user(template)) == NULLVP) {
	(void) fprintf(stderr, "%s: can't find user matching template.\n", 
		       myname);
	goto cleanup;
    }

    /* set up iocb */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.out_hdrs = header_out;
    iocbs.out_errs = error_out;

    /* process alias */

    r = pem_getkeydata(user, chaintype, &iocbs);

 cleanup:
    
    if (headerfile != (FILE *)0)
	fclose (headerfile);
    exit(r);
}

