#!/bin/sh

# James Galvin <galvin@tis.com>					4/94
# 
# This script expects to be invoked from a MIME user agent with arguments
# corresponding to a message encrypted with PEM.  A common configuration is
# for a MIME user agent to collect the parts of a multipart/encrypted content
# and invoke this script with those parts.
# 
# When using the Rand MH Version 6.8.3, the following addition to the user's
# .mh_profile file is recommended:
# 
# 	mhn-show-application/keys: pemdecrypt.sh %s %f %a

# Exactly 4 arguments are required, in the order indicated, as follows:
# 
# 	type	-- the MIME content type of the data to be decrypted;
# 	subtype	-- the MIME sub-content type; this information is
#		   currently unused
#	headers -- the file with the PEM header information
#	data	-- the file with the encrypted data
# 
# These 4 arguments may be preceded, followed, or separated by the following
# optional arguments:
# 
# 	-key		-- PEM annotations will include DEK
# 	-nokey		-- PEM annotations will not include DEK
# 	-recip		-- PEM annotations will list all recipients
# 	-norecip	-- PEM annotations will not list all recipients
# 
# If there are multiple occurances of any optional argument the last occurance
# will override all other occurances.


status=99
trap 'rm -f /tmp/dd$$ /tmp/dm$$; exit $status' 0 1 2 3 9 15


umask 077


# a helpful message is printed and then we exit; exit code argument required

usage() {
	echo Usage: $0: type subtype headers data 1>&2
	status=$1
	exit
}


# filchk is a convenience for doargs; filename argument is required

filchk() {
	if [ ! -f $1 ]; then
		echo $0: $1: not a file 1>&2
		usage 3
	fi
	if [ ! -r $1 ]; then
		echo $0: $1: unable to open for reading 1>&2
		usage 4
	fi
}

# parses the 4 required arguments

doargs() {
	if [ $# -ne 4 ]; then
		usage 2
	fi

	TYPE=$1
	STYP=$2
	HDRS=$3
	DATA=$4

	filchk $HDRS
	filchk $DATA
}


if [ $# -lt 4 ]; then
	usage 2
fi

ARGS=
KEY=
RECIP=

while [ $# -ge 1 ]; do
	case $1 in
	protocol=pem)
		;;

	-key)
		KEY="show-key yes" ;;
	-recip)
		RECIP="show-recips yes" ;;

	protocol=*)
		echo $0: unknown option \"$1\" 1>&2
		usage 1 ;;
	-*)
		echo $0: unknown option \"$1\" 1>&2
		usage 1 ;;

	*)	ARGS="$ARGS $1" ;;
	esac
	shift
done

doargs $ARGS

if [ -w /dev/tty -a -r /dev/tty ]; then
	decrypt $KEY $RECIP header-in $HDRS msg-out /tmp/dm$$ \
		data-in $DATA data-out /tmp/dd$$ 1>/dev/tty
	status=$?
else
	cat $DATA | decrypt $KEY $RECIP header-in $HDRS \
			msg-out /tmp/dm$$ > /tmp/dd$$
	status=$?
fi

if [ $status -ne 0 ]; then
	exit
fi

cat /tmp/dm$$ 1>2
cat /tmp/dd$$

status=0
exit
