/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "msg.h"
#include "new.h"
#include "user_list.h"
#include "util.h"

extern FILE *yyin;
extern struct msg *msg;

static int inputfd = 0; /* stdin by default */

static struct bbuf *data_in()
{
    return(cbfdread(inputfd));
}

static int error_out(bbuf)
struct bbuf *bbuf;
{
    (void) fprintf(stderr, "%s\n", bbuf -> data);
    (void) fflush(stderr);

    return(OK);
}

main(argc, argv)
int argc;
char **argv;
{
    FILE             *hdrs = (FILE *)0;
    FILE             *data = (FILE *)0;
    struct cbstruct   iocbs;
    char            **origuser = NULLVP;
    char            **origpk = NULLVP;
    char            **localopts = NULLVP;
    char            **dataname = NULLVP;
    char            **headername = NULLVP;
    char            **me = NULLVP;
    char             *pu = NULLCP;
    int               status = NOTOK;
    struct user_list *root = NULLUL,
                     *valid_path = NULLUL;


    /*  initialize TIS/PEM  */
    if (pem_init(argc, argv, &localopts) != OK) {
	fprintf(stderr, "%s: initialization failure\n", argv[0]);
	goto cleanup;
    }

    /*  process args */

    headername = tag_user(localopts, "header-in");
    dataname = tag_user(localopts, "data-in");

    if (headername == NULLVP || (argc == 2 && !strcasecmp(argv[1], "help"))) {
	(void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
	(void) fprintf(stderr, 
		       "Usage: %s header-in <filename> [data-in <filename>]\n",
		       myname);
	exit(1);
    }

    if ((hdrs = fopen(*(headername+1), "r")) == (FILE *)0) {
	(void) fprintf(stderr, "%s: unable to read header-in file %s\n", 
		       myname, *(headername+1));
	goto cleanup;
    }

    if (dataname != NULLVP) 
        if ((data = fopen(*(dataname+1), "r")) != (FILE *)0) 
            inputfd = fileno(data);
        else {
            fprintf(stderr, "%s: unable to open data-in file %s\n",
                    myname, *(dataname+1));
            goto cleanup;
        }

    msg = alloc_msg();

    yyin = hdrs;
    if (yyparse()) {
	(void) fprintf(stderr,"%s: improperly formatted headers\n", myname);
	goto cleanup;
    }

    if (msg -> origusers == NULLUL) {
	(void) fprintf(stderr, "%s: missing Originator-ID: field\n", myname);
	goto cleanup;
    }
    
    /* Make sure we have enough info in the msg to verify it */
    /* Also save key/name pair if it's new */

    rewind_indexfile();
    if ((origuser = get_tvt_user(msg->origusers->user)) == NULLVP) {

        /* Nope, so see if we have the public key plus a new name form */
       
        if ((origpk = tag_user(msg->origusers->user,"public-key")) == NULLVP) {
	    /* No key anywhere */
	    (void)fprintf(stderr,"%s: no public key for originator\n",myname);
	    goto cleanup;
	}
	
	rewind_indexfile();
	origuser = get_tv_user(*origpk, *(origpk+1));
	if (origuser == NULLVP || tag_user(origuser, "trusted") == NULLVP) {
	    msg->origusers->user = merge_user(msg->origusers->user,
					      origuser);
	    if (update_indexfile(NULLVP, msg->origusers->user) != OK) 
		(void)fprintf(stderr,
			      "%s: Unable to update database; continuing...\n",
			      myname);
	    FREE_AV(origuser);
	    origuser = msg->origusers->user;
	    msg->origusers->user = NULLVP;
	}
    }

    /* update user record in msg structure */

    FREE_AV(msg->origusers->user);
    msg->origusers->user = origuser;
    origuser = NULLVP;

    /* get my user records so I know where the root is */

 {
    char  **myalias = NULLVP;

    if ((myalias = tag_user(user_tailor, "my-alias")) == NULLVP) {
	fprintf(stderr, "%s: missing my-alias.\n", *argv);
	goto cleanup;
    }

    rewind_indexfile();
    while ((me = get_tv_user("alias", *(myalias+1))) != NULLVP) {
	struct user_list *up;

	up = alloc_ul();
	up->user = me;
	up->next = root;
	root = up;
    }
    if (root == NULLUL) {
	(void) fprintf(stderr, "%s: missing user for tag my-alias value %s\n",
		       *argv, *(myalias+1));
	goto cleanup;
    }
 }

    pu = pretty_user(msg->origusers->user);
    fprintf(stderr, "Originator: %s\n", pu);
    FREE(pu);
    valid_path = validate_user(msg->origusers->user, root);
    if (valid_path == NULLUL)
	fprintf(stderr, "Originator's public key is untrusted!\n");
    else {
	struct user_list *ul;

	fprintf(stderr, "Originator's public key is trusted by:\n");
	for (ul = valid_path; ul != NULLUL; ul = ul->next) {
	    pu = pretty_user(ul->user);
	    fprintf(stderr, "\t%s\n", pu);
	    FREE(pu);
	}
    }

    BZERO(&iocbs, sizeof(struct cbstruct));
    iocbs.in_data = data_in;	
    iocbs.out_errs = error_out;

    if (pem_verify(msg, &iocbs) != OK) {
	fprintf(stderr, "\n%s: unable to verify signature\n", myname);
	goto cleanup;
    }

    if (valid_path == NULLUL)
	fprintf(stderr,
	"\nSignature has been verified with an untrusted public key!\n");
    else
	fprintf(stderr,
		"\nSignature has been verified with a trusted public key.\n");

    status = OK;

 cleanup:

    if (hdrs != (FILE *)0)
	fclose(hdrs);
    if (data != (FILE *)0)
	fclose(data);

    FREE_AV(origuser);
    FREE_MSG(msg);

    exit(status);
}
