/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_bits(ebits, dbits, rlength)
struct bbuf *ebits;
struct bbuf **dbits;
int *rlength;
{
    int id, length, llen;
    struct bbuf *bb = NULLBB;
    int r = OK;
	
    if (ebits == (struct bbuf *)0) {
	return(NOTOK);
    }
    if (dbits == (struct bbuf **)0) {
	return(NOTOK);
    }
    if (*dbits != NULLBB) {
	(void) free_bbuf(*dbits);
	*dbits = NULLBB;
    }
    if (rlength == (int *)0) {
	return(NOTOK);
    }

    if (ebits->length < 2) {
	return(ASN1_ERR01);
    }

    /* CHECK FOR NULL */
    if ((id = ebits->data[0]) == (CLASS_UNIV|FORM_PRIM|PRIM_NULL)) {
	if (ebits->data[1] == 0x00) {
	    *rlength = 2;
	    return(OK);
	}
    }

    /* CHECK FOR UNIVERSAL PRIMITIVE BIT STRING */
    if (id != (CLASS_UNIV|FORM_PRIM|PRIM_BITS)) {
	return(ASN1_ERR02);
    }

    r = decode_len(&(ebits->data[1]), ebits->length-1, &length, &llen);
    if (r != OK) return(r);
    *rlength = 1 + llen + length;

    if ((bb = alloc_bbuf()) == NULLBB)
	return(NOTOK);

    bb->data = &ebits->data[1+llen];
    bb->length = length;

    if ((*dbits = prim2bits(bb)) == NULLBB) {
	r = ASN1_ERR20;
	goto cleanup;
    }

 cleanup:

    if (bb != NULLBB) {
	bb->data = (unsigned char *)0;
	(void) free_bbuf(bb);
    }

    return(r);
}
