/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

encode_ints(dints, eints)
struct bbuf *dints;
struct bbuf **eints;
{

    /* Check parameters */
    if (eints == (struct bbuf **)0) 
	return(NOTOK);

    if (*eints != NULLBB) {
	(void) free_bbuf(*eints);
	*eints = NULLBB;
    }

    if (dints != NULLBB) {

	/* Empty ints is interpreted as zero */
	if (dints->data == (unsigned char *)0) {
	    dints->data = alloc_uchar(sizeof(unsigned char));
	    dints->data[0] = 0x00;
	    dints->length = sizeof(unsigned char);
	}

	/* Check for malformed integer string */
	if (dints->length > sizeof(unsigned char) &&
	    (dints->data[0] == 0x00 && !(dints->data[1] & 0x80)) ||
	    (dints->data[0] == 0xff && (dints->data[1] & 0x80))) {
	    return(NOTOK);
	}
    }

    /* Encode it as a string */
    if (encode_str(dints, (CLASS_UNIV|FORM_PRIM|PRIM_INT), eints) != OK)
	return(NOTOK);

    return(OK);
}
