/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "allocate.h"
#include "bbuf.h"
#include "cert.h"
#include "util.h"

alloc_cert(cert)
struct certificate **cert;
{
    if (cert == (struct certificate **)0) {
	return(NOTOK);
    }

    allocate(cert, struct certificate, sizeof(struct certificate));

    if (*cert == NULL_CERT)
	return(ENOMEM);

    (*cert) -> tobesigned = NULL_TOBESIGNED;
    (*cert) -> sig_alg = NULL_ALGID;
    (*cert) -> sig = NULLBB;
    (*cert) -> status = BUNKNOWN;

    return(OK);
}

struct tobesigned *alloc_tobesigned_cert()
{
    struct tobesigned *p;

    allocate(&p, struct tobesigned, sizeof(struct tobesigned));

    if (p != NULL_TOBESIGNED) {
	p -> version = 0;
	p -> serial = NULLBB;
	p -> sig_alg = NULL_ALGID;
	p -> issuer = p -> subject = NULLBB;
	p -> valid = NULL_VALID;
	p -> public = NULLBB;
    }

    return(p);
}

struct valid *alloc_valid_cert()
{
    struct valid *p;

    allocate(&p, struct valid, sizeof(struct valid));

    if (p != NULL_VALID)
	p -> begin = p -> end = 0;

    return(p);
}
