/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "cert.h"
#include "util.h"

key_cert(ecert, ekey, mode)
struct bbuf **ecert;
struct bbuf  **ekey;
int mode;
{
    struct certificate *cert= NULL_CERT;
    int ret = NOTOK;

    if (ecert == (struct bbuf **)0) {
        goto cleanup;
    }
    if (ekey == (struct bbuf **)0) {
	goto cleanup;
    }
    if (decode_cert(*ecert, &cert) != OK) {
        goto cleanup;
    }

    switch (mode) {
    case READ:
	FREE_BBUF(*ekey);

	if (cert->tobesigned == NULL_TOBESIGNED
	    || cert->tobesigned->public == NULLBB) 
	    ret = OK;
        else if ((*ekey=dup_bbuf(cert->tobesigned->public)) == NULLBB)
	    ;
	else
	    ret = OK;

	goto cleanup;

    case WRITE:
	if (cert->tobesigned == NULL_TOBESIGNED
	    && (cert->tobesigned = alloc_tobesigned_cert())
	    == NULL_TOBESIGNED)
	    ;
	else
	    FREE_BBUF(cert->tobesigned->public);

	if (*ekey == NULLBB) 
	    ret = OK;
        else if ((cert->tobesigned->public=dup_bbuf(*ekey)) == NULLBB)
	    ;
        else if (encode_cert(cert, ecert) != OK)
	    ;
	else
	    ret = OK;

	goto cleanup;

    default:
	break;
    }

 cleanup:

    FREE_CERT(cert);
    return(ret);
}
