/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "allocate.h"
#include "util.h"

struct algent *
dupalgent(ae)
struct algent *ae;
{
    struct algent *a;

    if (ae == NULL_ALGENT)
	return(NULL_ALGENT);

    allocate(&a, struct algent, sizeof(struct algent));

    if (a != NULL_ALGENT) {
        a->code = ae->code;
        a->str = add2cp(NULLCP, ae->str);
	a->hdrstr = add2cp(NULLCP, ae->hdrstr);
	a->oidstr = add2cp(NULLCP, ae->oidstr);
        a->type = ae->type;
        a->minlen = ae->minlen;
        a->maxlen = ae->maxlen;
    }

    return(a);
}

/****************************************************************************/
