/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 *  cbdeciph_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./des.h"

static int readblock(inputcb, blocksize, block)
struct bbuf *(*inputcb)();
int blocksize;
unsigned char *block;
{
    static struct bbuf *buf = NULLBB;
    static int bufptr = 0;
  
    int blocklen = 0;
    int needed, have, chunk;

    while (blocklen < blocksize) {
	if (buf != NULLBB) {
	    if (buf->length == 0) {
		FREE_BBUF(buf);
		buf = NULLBB;
		bufptr = 0;
		return(blocklen);
	    }
	    needed = blocksize - blocklen;
	    have = buf->length - bufptr;
	    chunk = have > needed ? needed : have;
	    BCOPY(&(buf->data[bufptr]), &(block[blocklen]), chunk);
	    bufptr += chunk;
	    blocklen += chunk;
	    if (bufptr == buf->length) {
		FREE_BBUF (buf);
		buf = NULLBB;
	    }
	}
	else {			/* buf == NULLBB */
	    bufptr = 0;
	    if ((buf = inputcb()) == NULLBB) 
		return (blocklen);
	}
    }
    return (blocklen);
}

/****************************************************************************/

static int cbdecipher_descbc(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    unsigned char chain[DESBLKLEN]; /* intermediate block for chaining */
    struct bbuf *iv = NULLBB;	/* IV */
    int firsttime = 1;
    unsigned char	indata[DESBLKLEN],
			outdata[DESBLKLEN];
    struct bbuf outbuf;

    if (decode_deskeyparms(curparms, &iv) != OK)
	return(NOTOK);
    BCOPY(iv->data, chain, DESBLKLEN);
    FREE_BBUF(iv);
    outbuf.length = DESBLKLEN;
    outbuf.data = outdata;

    while (readblock(incb, DESBLKLEN, indata) == DESBLKLEN) {
	if (!firsttime)
	    (void) outcb(&outbuf);
	firsttime = 0;
	(void) cryptodes(indata, outdata);
	(void) bxor(outdata, chain, outdata, DESBLKLEN);
	BCOPY(indata, chain, DESBLKLEN);
    }

    outbuf.length = DESBLKLEN - (int)outdata[DESBLKLEN - 1];
    (void) outcb(&outbuf);

    return(OK);
}

/*****************************************************************************/

int cbdecipher_des(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    int r;
    struct bbuf *key = NULLBB;

    /* DECODE DES KEY DATA */
    if ((r = decode_deskeydata(curdata, &key)) != OK)
	goto cleanup;

    /* SET DES KEY FOR DECRYPTION */
    if (!setdeskey(CHECK, DECRYPT, key->data)) {
	r = NOTOK;
	goto cleanup;
    }

    /* DECRYPT WITH SPECIFIED MODE OF OPERATION */
    switch(curalg) {
    case DES_CBC:
	if ((r = cbdecipher_descbc(incb, outcb)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

cleanup:

    FREE_BBUF(key);

    return(r);
}

/****************************************************************************/
