/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 *  cbencipher_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "util.h"

#include "./des.h"

static int readblock(inputcb, blocksize, block)
struct bbuf *(*inputcb)();
int blocksize;
unsigned char *block;
{
    static struct bbuf *buf = NULLBB;
    static int bufptr = 0;
  
    int blocklen = 0;
    int needed, have, chunk;

    while (blocklen < blocksize) {
	if (buf != NULLBB) {
	    if (buf->length == 0) {
		FREE_BBUF(buf);
		buf = NULLBB;
		bufptr = 0;
		return(blocklen);
	    }
	    needed = blocksize - blocklen;
	    have = buf->length - bufptr;
	    chunk = have > needed ? needed : have;
	    BCOPY(&(buf->data[bufptr]), &(block[blocklen]), chunk);
	    bufptr += chunk;
	    blocklen += chunk;
	    if (bufptr == buf->length) {
		FREE_BBUF (buf);
		buf = NULLBB;
	    }
	}
	else {			/* buf == NULLBB */
	    bufptr = 0;
	    if ((buf = inputcb()) == NULLBB) 
		return (blocklen);
	}
    }
    return (blocklen);
}

/****************************************************************************/

static int cbencipher_descbc(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    register int i;		/* block index */
    struct bbuf *iv = NULLBB;	/* IV */
    int blklen;			/* input buffer length */
    unsigned char chain[DESBLKLEN]; /* intermediate block for chaining */
    unsigned char indata[DESBLKLEN]; /* input block */
    unsigned char outdata[DESBLKLEN]; /* output block */
    struct bbuf outbuf;
    int padlen;

    if (decode_deskeyparms(curparms, &iv) != OK)
	return(NOTOK);
    BCOPY(iv->data, chain, DESBLKLEN);
    FREE_BBUF(iv);
    outbuf.length = DESBLKLEN;
    outbuf.data = chain;

    while ((blklen = readblock(incb, DESBLKLEN, indata)) == DESBLKLEN) {
	(void) bxor(indata, chain, outdata, DESBLKLEN);
	(void) cryptodes(outdata, chain);
	(void) outcb(&outbuf);
    }

    padlen = DESBLKLEN - blklen;
    for (i=blklen; i<DESBLKLEN; i++) indata[i] = (unsigned char)padlen;
    (void) bxor(indata, chain, outdata, DESBLKLEN);
    (void) cryptodes(outdata, chain);
    (void) outcb (&outbuf);

    return(OK);
}

/****************************************************************************/

int cbencipher_des(incb, outcb)
struct bbuf *(*incb)();
int (*outcb)();
{
    int r;
    struct bbuf *key = NULLBB;

    /* DECODE DES KEY DATA */ 
    if ((r = decode_deskeydata(curdata,&key)) != OK) 
	goto cleanup;

    /* SET DES KEY FOR ENCRYPTION */
    if (!setdeskey(CHECK, ENCRYPT, key->data)) {
	r = NOTOK;
	goto cleanup;
    }

    /* ENCRYPT WITH SPECIFIED MODE OF OPERATION */
    switch(curalg) {
    case DES_CBC:
	if ((r = cbencipher_descbc(incb, outcb)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

 cleanup:

    FREE_BBUF(key);

    return(r);
}    

/****************************************************************************/
