/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * decode_deskey.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"

#include "./des.h"

/*****************************************************************************/

int decode_deskeyparms(eparms,dparms)
struct bbuf *eparms;
struct bbuf **dparms;
{
    int dummy;

    /* CHECK PARAMETERS */
    if (eparms == NULLBB || dparms == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*dparms);

    /* DECODE THE KEY PARAMETERS */
    return(decode_octs(eparms, dparms, &dummy));
}

/*****************************************************************************/

int decode_deskeydata(edata,ddata)
struct bbuf *edata;
struct bbuf **ddata;
{
    int dummy;

    /* CHECK PARAMETERS */
    if (edata == NULLBB || ddata == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*ddata);

    /* DECODE THE KEY DATA */
    return(decode_octs(edata, ddata, &dummy));
}

/*****************************************************************************/
