/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

 /****************************************************************************
  * disp_deskey.c 
  ****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./des.h"

int disp_deskeyparms(alg, parms, out)
int alg;
struct bbuf *parms;
char ***out;
{
    int r = OK;
    char *buf = NULLCP;
    struct bbuf *iv = NULLBB;

    /* DOUBLE-CHECK PARAMETERS */
    if (parms == NULLBB || out == (char ***)0) 
	return(NOTOK);

    /* DECODE AND ADD THE KEY PARAMETERS */
    buf = add2cp(buf, "parms: iv = ");
    if ((r = decode_deskeyparms(parms, &iv)) != OK)
	goto cleanup;
    if (iv == NULLBB) buf = add2cp(buf, "NULL");
    else buf = addhex2cp(buf, iv->data, iv->length);
    *out = add2av(*out, buf);

    r = OK;

cleanup:

    FREE_BBUF(iv);

    return(r);
}

/****************************************************************************/

disp_deskeydata(alg, data, out)
int alg;
struct bbuf *data;
char ***out;
{
    int r = OK;
    char *buf = NULLCP;
    struct bbuf *key = NULLBB;

    /* DOUBLE-CHECK PARAMETERS */
    if (data == NULLBB || out == (char ***)0) 
	return(NOTOK);

    /* DECODE AND ADD THE KEY DATA */
    buf = add2cp(buf, "data: key = ");
    if ((r = decode_deskeydata(data, &key)) != OK)
	goto cleanup;
    if (key == NULLBB) buf = add2cp(buf, "NULL");
    else buf = addhex2cp(buf, key->data, key->length);
    *out = add2av(*out, buf);

cleanup:

    FREE_BBUF(key);

    return(r);
}

/****************************************************************************/
