/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 *  enciph_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./des.h"

/****************************************************************************/

int encipher_des(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int r;
    struct bbuf *key = NULLBB;

    /* DOUBLE-CHECK PARAMETERS */
    if (in == NULLBB || out == (struct bbuf **)0) 
	return(NOTOK);

    /* DECODE DES KEY DATA */
    if ((r = decode_deskeydata(curdata, &key)) != OK)
        return(NOTOK);

    /* SET DES KEY FOR ENCRYPTION */
    if (!setdeskey(CHECK, ENCRYPT, key->data)) {
        r = NOTOK;
        goto cleanup;
    }

    /* ENCRYPT WITH SPECIFIED MODE OF OPERATION */
    switch(curalg) {
    case DES_CBC:
	if ((r = encipher_descbc(in, out)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

cleanup:

    FREE_BBUF(key);

    return(r);
}

/****************************************************************************/

static int encipher_descbc(in, out)
struct bbuf *in;
struct bbuf **out;
{
    register int i;			/* block index */
    register int j, k;			/* byte indices */
    struct bbuf *iv = NULLBB;		/* IV */
    unsigned char chain[DESBLKLEN];	/* intermediate block for chaining */
    int padlen;			        /* length of padding */
    int inlen;			        /* input buffer length */
    unsigned char *indata, *outdata;    /* input and output buffer pointers */
    unsigned char lastblock[DESBLKLEN]; /* last block w/ input & padding */

    /* SET LENGTHS */
    inlen = in->length;
    indata = in->data;
    padlen = DESBLKLEN - (inlen % DESBLKLEN); /* always pad 1-DESBLKLEN bytes */

    /* ALLOCATE ENCRYPTED OUTPUT BUFFER */
    *out = alloc_bbuf();
    (*out)->length = inlen + padlen;
    (*out) -> data = alloc_uchar((*out) -> length);
    outdata = (*out)->data;

    /* INITIAL CHAIN BLOCK IS IV */
    if (decode_deskeyparms(curparms, &iv) != OK)
	return(NOTOK);
    BCOPY(iv->data, chain, DESBLKLEN);
    FREE_BBUF(iv);

    /* ENCRYPT ALL BUT FINAL, PADDED BLOCK */
    for (i=0; i<inlen-(DESBLKLEN-1); i+=DESBLKLEN) {
	(void) bxor(indata+i, chain, outdata+i, DESBLKLEN);
	(void) cryptodes(outdata+i, outdata+i);
	BCOPY(outdata+i, chain, DESBLKLEN);
    }

    /* PAD FINAL BLOCK WITH PAD LENGTH AND ENCRYPT */
    for (j=i, k=0; j<inlen; j++, k++) lastblock[k] = indata[j];
    for (; j<inlen+padlen; j++, k++) lastblock[k] = (unsigned char)padlen;
    (void) bxor(lastblock, chain, outdata+i, DESBLKLEN);
    (void) cryptodes(outdata+i, outdata+i);

    return(OK);
}

/****************************************************************************/
