/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 *  fdecipher_des.c
 *****************************************************************************/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./des.h"

int fdecipher_des(fin, fout)
FILE *fin;
FILE *fout;
{
    int r;
    struct bbuf *key = NULLBB;

    /* DOUBLE-CHECK PARAMETERS */
    if (fin == (FILE *)0 || fout == (FILE *)0)
	return(NOTOK);

    /* DECODE DES KEY DATA */
    if ((r = decode_deskeydata(curdata, &key)) != OK)
        return(NOTOK);

    /* SET DES KEY FOR DECRYPTION */
    if (!setdeskey(CHECK, DECRYPT, key->data)) {
        r = NOTOK;
        goto cleanup;
    }

    /* DECRYPT WITH SPECIFIED MODE OF OPERATION */
    switch(curalg) {
    case DES_CBC:
	if ((r = fdecipher_descbc(fin, fout)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;
    
cleanup:

    FREE_BBUF(key);

    return(r);
}    

/****************************************************************************/

static int fdecipher_descbc(fin, fout)
FILE *fin;
FILE *fout;
{
    unsigned char chain[DESBLKLEN];	/* intermediate block for chaining */
    struct bbuf *iv = NULLBB;		/* IV */
    int blklen;				/* block length */
    unsigned char indata[DESBLKLEN];	/* input block */
    unsigned char outdata[DESBLKLEN];	/* output block */
    int padlen;

    if (decode_deskeyparms(curparms, &iv) != OK)
	return(NOTOK);
    BCOPY(iv->data, chain, DESBLKLEN);
    FREE_BBUF(iv);

    blklen = fread((char *)indata,1,DESBLKLEN,fin);

    while (blklen) {

	/* check that blklen == DESBLKLEN */
	if (blklen != DESBLKLEN) 
	    return(NOTOK);

	/* decipher the block */
	(void) cryptodes(indata, outdata);
	(void) bxor(outdata, chain, outdata, DESBLKLEN);
	BCOPY(indata, chain, DESBLKLEN);

	/* another block? */
        blklen = fread((char *)indata,1,DESBLKLEN,fin);
	if (blklen) {
	    (void) fwrite((char *)outdata,1,DESBLKLEN,fout);
	    continue;
	}

	/* final block */
	padlen = outdata[DESBLKLEN-1];
	if (DESBLKLEN-padlen)
	    (void) fwrite((char *)outdata,1,DESBLKLEN-padlen,fout);
    }

    return(OK);
}

/****************************************************************************/
