/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * str2desparms.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

#include "./des.h"

int str2desparms(str, dek)
char *str;
struct key **dek;
{
    int r, alg;
    struct bbuf **parms;
    struct bbuf *ivbb = NULLBB;

    if (str == NULLCP || dek == (struct key **)0)
	return(NOTOK);

    if ((*dek)->algid == NULL_ALGID) 
	return(NOTOK);

    alg = (*dek)->algid->alg;

    switch(alg) {
    case DES:
    case DES_CBC:
	if (strlen(str) != 2*DESIVLEN)
	    return(NOTOK);
	parms = &((*dek)->algid->parms);
	if ((ivbb = hex2bin(str)) == NULLBB)
	    return(NOTOK);
	if ((r = encode_deskeyparms(ivbb, parms)) != OK) {
	    FREE_BBUF(ivbb);
	    return(r);
	}
	FREE_BBUF(ivbb);
	break;

    case DES_ECB:
    case DES_EDE:
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}

/*****************************************************************************/
