/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * algid_key.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "key.h"

algid_key(ekey, aid, mode)
struct bbuf **ekey;
struct algid **aid;
int mode;
{
    int ret = NOTOK;
    struct key *key= NULL_KEY;

    /* DOUBLE-CHECK PARAMETERS */
    if (ekey == (struct bbuf **)0 || *ekey == NULLBB) 
	goto cleanup;

    if (aid == (struct algid **)0) 
	goto cleanup;

    if (decode_key(*ekey, &key) != OK) 
	goto cleanup;

    switch (mode) {
    case READ:
        FREE_ALGID(*aid);

	if (key->algid != NULL_ALGID &&
	    (*aid = dup_algid(key->algid)) == NULL_ALGID)
	    goto cleanup;

	ret = OK;

	break;

    case WRITE:
	FREE_ALGID(key->algid);

	if (*aid != NULL_ALGID &&
	    (key->algid = dup_algid(*aid)) == NULL_ALGID)
	    goto cleanup;

        ret = encode_key(key, ekey);

	break;

    default:
	goto cleanup;
    }

 cleanup:

    FREE_KEY(key);
    return(ret);
}

/****************************************************************************/
