/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * setparity.c    set right-most (8th) bit of each octet for odd parity
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"

int setparity(data)
struct bbuf *data;
{
    int i, j, parity;
    unsigned char c;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (data == NULLBB) 
	return(NOTOK);

    /* SET ODD PARITY FOR EACH OCTET */
    for (i=0; i<data->length; i++) {
	c = data->data[i];
	parity = 0;
	/* count number of one's in all 8 bits */
	for (j=0; j<8; j++) {
	    if (c & 0x01) parity++;
	    c >>= 1;
	}
	/* if even number of one's, then flip 8th bit */
	if (!(parity & 0x01)) data->data[i] ^= 0x01;
    }

    return(OK);
}

/***************************************************************************/
