/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "util.h"

#include "./rsa.h"

/****************************************************************************/

int disp_rsakeyparms(alg, parms, out)
int alg;
struct bbuf *parms;
char ***out;
{
    int r;
    char *cp = NULLCP;
    int len;

    /* DOUBLE-CHECK PARAMETERS */
    if (parms == NULLBB) 
	return(NOTOK);

    if (out == (char ***)0) 
	return(NOTOK);

    /* DECODE THE PARMS INTO AN INT */
    if ((r = decode_rsakeyparms(alg, parms, &len)) != OK)
	return(NOTOK);

    *out = add2av (*out, add2cp (NULLCP, "parameters:"));
    cp = add2cp (cp, "    length: ");
    cp = addint2cp(cp, len);
    *out = add2av(*out, cp);

    r = OK;

    if (r != OK)
	FREE_AV(*out);

    return(r);
}

/****************************************************************************/

int disp_rsakeydata(alg, data, out)
int alg;
struct bbuf *data;
char ***out;
{
    int r;
    R_RSA_PUBLIC_KEY Pu;
    R_RSA_PRIVATE_KEY Pr;

    /* DOUBLE-CHECK PARAMETERS */
    if (data == NULLBB || out == (char ***)0) 
	return(NOTOK);

    /* PREDECODE THE DATA TO ENSURE KEY SUBALG IS KNOWN */
    if ((r = predecode_rsakeydata(data, &alg)) != OK)
	return(NOTOK);

    /* DISPLAY KEY DATA */
    switch (alg) {
    case RSA_PUB:
    case RSA_PUB3:
    case RSA_PUBF4:
    case RSAENC_PUB:
    case RSAENC_PUB3:
    case RSAENC_PUBF4:
        if ((r = decode_rsapubkeydata(data, &Pu)) != OK) {
	    r = NOTOK;
	    goto cleanup;
	}
	(void) disp_rsapubkeydata(&Pu, out);
	break;

    case RSA_PRIV:
    case RSAENC_PRIV:
        if ((r = decode_rsaprikeydata(data, &Pr)) != OK) {
	    r = NOTOK;
	    goto cleanup;
	}
	(void) disp_rsaprikeydata(&Pr, out);
	break;

    default:
	r = NOTOK;
	goto cleanup;
	break;
    }

    r = OK;

 cleanup:

    if (r != OK)
	FREE_AV(*out);

    return(r);
}

/****************************************************************************/

static int disp_rsapubkeydata(Pu, out)
R_RSA_PUBLIC_KEY *Pu;
char ***out;
{
    char *cp = NULLCP;

    /* PROCESS & ADD EACH VALUE TO OUT AV */
    *out = add2av(*out, add2cp(cp, "data:"));
    cp = add2cp(cp, "    bits: ");
    cp = addint2cp(cp, (int)Pu->bits);
    *out = add2av(*out, cp);
    cp = NULLCP;
    (void) addvalue2av("    N: ", Pu->modulus, MAX_RSA_MODULUS_LEN, out); 
    (void) addvalue2av("    E: ", Pu->exponent, MAX_RSA_MODULUS_LEN, out); 

    return(OK);
}

/****************************************************************************/

static int disp_rsaprikeydata(Pr, out)
R_RSA_PRIVATE_KEY *Pr;
char ***out;
{
    char *cp = NULLCP;

    /* PROCESS & ADD EACH VALUE TO OUT AV */
    *out = add2av (*out, add2cp(cp, "data:"));
    cp = add2cp(cp, "    bits: ");
    cp = addint2cp(cp, (int)Pr->bits);
    *out = add2av(*out, cp);
    cp = NULLCP;
    (void)addvalue2av("    N: ",Pr->modulus,MAX_RSA_MODULUS_LEN, out); 
    (void)addvalue2av("    E: ",Pr->publicExponent,MAX_RSA_MODULUS_LEN, out); 
    (void)addvalue2av("    D: ",Pr->exponent,MAX_RSA_MODULUS_LEN, out); 
    (void)addvalue2av("    P: ",Pr->prime[0],MAX_RSA_PRIME_LEN, out); 
    (void)addvalue2av("    Q: ",Pr->prime[1],MAX_RSA_PRIME_LEN, out); 
    (void)addvalue2av("    DP: ",Pr->primeExponent[0],MAX_RSA_PRIME_LEN, out); 
    (void)addvalue2av("    DQ: ",Pr->primeExponent[1],MAX_RSA_PRIME_LEN, out); 
    (void)addvalue2av("    CR: ",Pr->coefficient,MAX_RSA_PRIME_LEN, out); 

    return(OK);
}

/****************************************************************************/

static int addvalue2av(s, b, l, out)
char *s;
unsigned char *b;
int l;
char ***out;
{
    int i;
    char *cp = NULLCP;

    cp = add2cp(cp, s);
    for (i=0; i<l-1 && b[i]==NULLUC && !(b[i+1] & 0x80); i++) 
	;
    cp = addhex2cp(cp, b+i, (int)l-i);
    *out = add2av(*out, cp);
}

/****************************************************************************/
