/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * enciph_rsa.c
 ****************************************************************************/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./rsa.h"

int encipher_rsa(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int r;
    R_RSA_PUBLIC_KEY Pu;
    struct bbuf *seed = NULLBB;
    R_RANDOM_STRUCT Rs;
    unsigned int bytesNeeded;
    unsigned char tmp[MAX_RSA_MODULUS_LEN];
    unsigned int tmplen;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (in == NULLBB || out == (struct bbuf **)0)
	return(NOTOK);

    FREE_BBUF(*out);

    /* PREDECODE RSA KEY DATA */
    if ((r = predecode_rsakeydata(curdata, &curalg)) != OK)
	return(r);

    /* DECODE RSA PUBLIC KEY DATA */
    switch (curalg) {
    case RSA_PUB:
    case RSA_PUB3:
    case RSA_PUBF4:
    case RSAENC_PUB:
    case RSAENC_PUB3:
    case RSAENC_PUBF4:
        if ((r = decode_rsapubkeydata(curdata, &Pu)) != OK)
	    return(r);
	break;

    default:
	return(NOTOK);
    }

    /* CHECK THAT KEY LENGTH IS WITHIN IMPLEMENTATION RANGE */
    if (Pu.bits < MIN_RSA_MODULUS_BITS || Pu.bits > MAX_RSA_MODULUS_BITS) 
        return(NOTOK);

    /* PREPARE RSAREF RANDOM STRUCTURE */
    R_RandomInit(&Rs);
    while (1) {
        R_GetRandomBytesNeeded(&bytesNeeded, &Rs);
        if (bytesNeeded == 0) break;
        if ((seed = pseudorandom(RSASEEDSIZE)) == NULLBB) 
            return(NOTOK);

        R_RandomUpdate(&Rs, seed->data, (unsigned int)seed->length);
        FREE_BBUF(seed);
    }

    /* ENCIPHER THE INPUT DATA */
    r = RSAPublicEncrypt(tmp, &tmplen, in->data, (unsigned)in->length,
			 &Pu, &Rs);
    if (r != 0) 
	return(NOTOK);

    /* ALLOCATE OUTPUT BBUF */
    *out = alloc_bbuf();
    (*out)->length = tmplen;
    (*out) -> data = alloc_uchar((*out) -> length);

    /* COPY ENCIPHERED DATA INTO OUTPUT BBUF */
    BCOPY(tmp, (*out)->data, (*out)->length);

    return(OK);
}

/****************************************************************************/
